/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipInputStream;
import org.flasck.flas.parsedForm.assembly.Assembly;
import org.flasck.flas.repository.AssemblyLeaves;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.assembly.ApplicationAssembly;
import org.flasck.jvm.assembly.CardInitializer;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.deployment.fl.JVMApplicationAssembly;
import org.ziniki.deployment.fl.JVMCardInitializer;
import org.ziniki.deployment.fl.JVMPackageInfo;
import org.zinutils.utils.FileUtils;

public abstract class BuildApplicationAssembly
extends AssemblyLeaves {
    protected static final Logger logger = LoggerFactory.getLogger((String)"main");
    private final ByteArrayOutputStream templates = new ByteArrayOutputStream();
    private final Map<String, ContentObject> assets = new TreeMap<String, ContentObject>();
    private final PrintWriter tpw = new PrintWriter(this.templates);
    protected String aname;
    private JVMApplicationAssembly store;
    private List<ContentObject> jslibs = new ArrayList<ContentObject>();
    private List<ContentObject> cssfiles = new ArrayList<ContentObject>();
    private List<CardInitializer> inits = new ArrayList<CardInitializer>();
    protected final FLEvalContext cx;

    public BuildApplicationAssembly(FLEvalContext cx) {
        this.cx = cx;
    }

    public void visitAssembly(Assembly a) {
        this.aname = a.name().uniqueName();
        this.store = new JVMApplicationAssembly(this.cx);
        if (a instanceof org.flasck.flas.parsedForm.assembly.ApplicationAssembly) {
            org.flasck.flas.parsedForm.assembly.ApplicationAssembly aa = (org.flasck.flas.parsedForm.assembly.ApplicationAssembly)a;
            if (aa.getTitle() != null) {
                this.store.set("title", (Object)aa.getTitle());
            }
            JVMCardInitializer init = new JVMCardInitializer(this.cx, a.name().uniqueName());
            this.inits.add((CardInitializer)init);
        }
        this.store.set("assets", this.assets);
        ArrayList<JVMPackageInfo> packages = new ArrayList<JVMPackageInfo>();
        this.store.set("packages", packages);
        JVMPackageInfo pi = new JVMPackageInfo(this.cx);
        packages.add(pi);
        pi.set("javascript", this.jslibs);
        pi.set("css", this.cssfiles);
        pi.set("inits", this.inits);
    }

    public void includePackageFile(ContentObject co) {
        if (co instanceof FileContentObject) {
            return;
        }
        this.jslibs.add(co);
    }

    public void visitPackage(String pkg) {
        if (!this.inits.isEmpty()) {
            JVMCardInitializer init = (JVMCardInitializer)this.inits.get(0);
            init.addPackage(pkg);
        }
    }

    public void visitCardTemplate(String cardName, InputStream is, long length) throws IOException {
        this.tpw.println("    <template id='" + cardName + "'>");
        this.tpw.flush();
        FileUtils.copyStreamWithoutClosingEither((InputStream)is, (OutputStream)this.templates);
        this.tpw.println("\n    </template>");
        this.tpw.flush();
    }

    public void visitCSS(String name, ZipInputStream zis, long length) throws IOException {
        byte[] bs = FileUtils.readAllStream((InputStream)zis);
        ContentObject co = this.uploadResource("css", name, new ByteArrayInputStream(bs), bs.length, false, "text/css");
        this.cssfiles.add(co);
        this.assets.put(name, co);
    }

    public void visitResource(String name, ZipInputStream zis) throws IOException {
        byte[] bs = zis.readAllBytes();
        ContentObject co = this.uploadResource("resources", name, new ByteArrayInputStream(bs), bs.length, false, "application/octet-stream");
        this.assets.put(name, co);
    }

    public void leaveAssembly(Assembly a) throws IOException {
        this.tpw.flush();
        byte[] bs = this.templates.toByteArray();
        if (bs.length > 0) {
            ContentObject co = this.uploadResource("templates", "templates", new ByteArrayInputStream(bs), bs.length, false, "text/html");
            this.store.set("templates", (Object)co);
        }
        this.save((ApplicationAssembly)this.store);
        this.store = null;
        this.jslibs = null;
    }

    protected abstract ContentObject get(String var1);

    protected abstract ContentObject uploadJs(File var1);

    protected abstract ContentObject uploadResource(String var1, String var2, InputStream var3, long var4, boolean var6, String var7) throws IOException;

    protected abstract void save(ApplicationAssembly var1);

    public void traversalDone() throws Exception {
    }
}

