/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.CodePackageVersion;
import org.ziniki.DataHandler;
import org.ziniki.DataStore;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class AttachWebZip
implements RelationHandler {
    private String packageName;
    private String version;
    private List<ContentObject> cos;
    private IdempotentHandler ih;
    private FLEvalContext cx;

    public AttachWebZip(ContentStorage cs, ZiIdFactory factory, UnitOfWork uow, DataStore ds, ZiId appArena, String packageName, String version, List<ContentObject> cos, IdempotentHandler ih) {
        this.packageName = packageName;
        this.version = version;
        this.cos = cos;
        this.ih = ih;
        this.cx = (FLEvalContext)uow;
    }

    public DataHandler doWork(Relation r) {
        return new OnceAttached(r, this.packageName, this.version);
    }

    public void attach(Relation r, @Slot(value="codepkgvers") CodePackageVersion codepkgvers) {
        codepkgvers.set("webzips", this.cos);
        r.update(codepkgvers.id(), (Object)codepkgvers);
    }

    public void reply() {
        this.ih.success((EvalContext)this.cx);
    }

    public void error(TxError error) {
        String msg = "unknown error";
        if (error != null) {
            msg = error.toString();
        }
        this.ih.failure((EvalContext)this.cx, (Object)msg);
    }

    public static final class OnceAttached
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final String packageName;
        private final String version;

        public OnceAttached(Relation r, String packageName, String version) {
            this.r = r;
            this.packageName = packageName;
            this.version = version;
        }

        public String _handlerID() {
            return null;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException("There is no package " + this.packageName + ":" + this.version));
            return null;
        }

        public Object value(FLEvalContext cx, Object[] args) {
            try {
                this.r.load("codepkgvers", args[0]);
                this.r.logic("attach");
            }
            catch (Throwable t) {
                ((UnitOfWork)cx).fatalError(t);
            }
            return null;
        }

        public Object name() {
            return null;
        }
    }
}

