/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.TypeOf;
import org.flasck.jvm.fl.JVMFieldsContainerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.CrobagUpdateHandler;
import org.ziniki.DataHandler;
import org.ziniki.DataStore;
import org.ziniki.EntityCreated;
import org.ziniki.common.UOWHost;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.concepts.Arena;
import org.ziniki.interfaces.Secondary;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.intf.ZinikiUOW;
import org.ziniki.services.datastore.AddBenchToArena;
import org.ziniki.services.datastore.AttachPersonalArena;
import org.ziniki.services.datastore.AttachSecondaryIndex;
import org.ziniki.services.datastore.AttachSecondaryKeyset;
import org.ziniki.services.datastore.CreateAnArena;
import org.ziniki.services.datastore.FetchMy;
import org.ziniki.services.datastore.GetSecondaryByType;
import org.ziniki.services.datastore.GetSecondaryIndex;
import org.ziniki.services.datastore.GetSecondaryKey;
import org.ziniki.services.datastore.JoinArena;
import org.ziniki.services.datastore.PublishToArena;
import org.ziniki.services.datastore.PutEntity;
import org.ziniki.services.datastore.PutMy;
import org.ziniki.services.datastore.SubscribeTo;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.reflection.Reflection;

public class ZinikiDataStore
implements DataStore {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final TDAStorage storage;
    private final ZiIdFactory factory;
    private final ClassLoader loader;
    private final HandlerNameProvider nameProvider;

    public ZinikiDataStore(@Param(value="broker") ZiwshBroker broker, @Param(value="storage") TDAStorage storage, @Param(value="factory") ZiIdFactory factory, @Param(value="classLoader") ClassLoader loader, @Param(value="handlerNameProvider") HandlerNameProvider nameProvider) {
        this.storage = storage;
        this.factory = factory;
        this.loader = loader;
        this.nameProvider = nameProvider;
        broker.register(DataStore.class, (Object)this);
    }

    public Object name() {
        return this.getClass().getName();
    }

    public Object subscribe(FLEvalContext cx, Object[] args) {
        String simple;
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        DataHandler handler = (DataHandler)args[1];
        if (args[0] instanceof String) {
            simple = (String)args[0];
        } else if (args[0] instanceof ZiId) {
            simple = args[0].toString();
        } else {
            handler.failure((EvalContext)cx, (Object)"invalid id");
            return null;
        }
        Relation r = uow.relation((RelationHandler)new SubscribeTo(this.storage, uow, simple, handler));
        try {
            r.get("item", simple);
            r.logic("returnAndSubscribe");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object domain(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        String name = (String)args[0];
        DataHandler handler = (DataHandler)args[1];
        ZiId ziid = this.factory.unique("ziniki", name, "domain");
        Relation r = uow.relation((RelationHandler)new SubscribeTo(this.storage, uow, ziid.toString(), handler));
        try {
            r.get("item", ziid.toString());
            r.logic("returnAndSubscribe");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object put(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        FieldsContainerWrapper e = (FieldsContainerWrapper)args[0];
        IdempotentHandler ih = (IdempotentHandler)args[1];
        String eid = (String)e.get("_id");
        logger.info("Want to put " + eid + "." + e.get("_version"));
        Relation r = uow.relation((RelationHandler)new PutEntity(cx, uow, eid, e, ih));
        try {
            this.permissions(r, "perms", zx.userIdentity(), eid);
            r.get("current", eid);
            r.links("benches", "EntityBench", eid);
            r.logic("findSecondaries");
            r.logic("checkSecondaries");
            r.logic("putRecord");
            r.whenCommitted("sendHappyResponse");
            r.whenRolledBack("sendFailureResponse");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object createArena(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        Arena parent = (Arena)args[0];
        String onbench = (String)args[1];
        JVMFieldsContainerWrapper proto = (JVMFieldsContainerWrapper)args[2];
        EntityCreated handler = (EntityCreated)args[3];
        logger.info("Want to create arena inside " + parent.ziid());
        Relation r = uow.relation((RelationHandler)new CreateAnArena(cx, uow, this.factory, onbench, proto, handler));
        try {
            String pid = parent.ziid().toString();
            this.permissions(r, "perms", zx.userIdentity(), pid);
            r.get("parent", pid);
            r.links("secondaries", "SecondaryInArena", pid);
            r.logic("createIt");
            r.whenCommitted("sendHappyResponse");
            r.whenRolledBack("sendFailureResponse");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object addBench(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        FieldsContainerWrapper arena = (FieldsContainerWrapper)args[0];
        String bench = (String)args[1];
        List perms = (List)args[2];
        IdempotentHandler handler = (IdempotentHandler)args[3];
        logger.info("Want to add bench " + bench + " to arena " + arena.id() + " with permissions " + perms);
        Relation r = uow.relation((RelationHandler)new AddBenchToArena(cx, uow, bench, perms, handler));
        try {
            this.permissions(r, "perms", zx.userIdentity(), arena.id());
            r.get("arena", arena.id());
            r.logic("createBenchInArena");
            r.whenCommitted("sendHappyResponse");
            r.whenRolledBack("sendFailureResponse");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object join(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        FieldsContainerWrapper arena = (FieldsContainerWrapper)args[0];
        String bench = (String)args[1];
        FieldsContainerWrapper persona = (FieldsContainerWrapper)args[2];
        IdempotentHandler handler = (IdempotentHandler)args[3];
        if (arena == null || arena.id() == null) {
            handler.failure((EvalContext)cx, (Object)"must have a valid arena to join");
            return null;
        }
        if (persona == null) {
            handler.failure((EvalContext)cx, (Object)"must have a persona to present to arena");
            return null;
        }
        logger.info("Want to join " + zx.userIdentity() + " to " + arena.id() + " on bench " + bench + " with persona " + persona);
        Relation r = uow.relation((RelationHandler)new JoinArena(cx, uow, this.factory, bench, zx.userIdentity(), persona, handler));
        try {
            this.permissions(r, "perms", zx.userIdentity(), arena.id());
            r.get("arena", arena.id());
            r.logic("joinArena");
            r.whenCommitted("sendHappyResponse");
            r.whenRolledBack("sendFailureResponse");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object publish(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new InvalidUsageException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new InvalidUsageException("There is no identity in ZX trait");
        }
        FieldsContainerWrapper e = (FieldsContainerWrapper)args[0];
        FieldsContainerWrapper arena = (FieldsContainerWrapper)args[1];
        List benches = (List)args[2];
        IdempotentHandler handler = (IdempotentHandler)args[3];
        if (e == null || e.id() == null) {
            handler.failure((EvalContext)cx, (Object)"must have a saved object to publish");
            return null;
        }
        if (arena == null || arena.id() == null) {
            handler.failure((EvalContext)cx, (Object)"must have a valid arena to publish to");
            return null;
        }
        logger.info("Want to publish " + e.id() + " to " + arena.id() + " and make available on benches " + benches);
        Relation r = uow.relation((RelationHandler)new PublishToArena(cx, this.loader, uow, benches, handler));
        try {
            this.permissions(r, "perms", zx.userIdentity(), arena.id());
            r.get("thing", e.id());
            r.get("arena", arena.id());
            r.links("secondaries", "SecondaryInArena", arena.id());
            r.logic("publishToArena");
            r.whenCommitted("sendHappyResponse");
            r.whenRolledBack("sendFailureResponse");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object attachPersonalArena(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        ZiId user = zx.userIdentity();
        FieldsContainerWrapper entity = (FieldsContainerWrapper)args[0];
        EntityCreated handler = (EntityCreated)args[1];
        Relation r = uow.relation((RelationHandler)new AttachPersonalArena(this.factory, uow, zx, entity, handler));
        try {
            if (entity.has("_id")) {
                throw new NotImplementedException("do not yet handle attaching existing objects to the personal arena - has security considerations");
            }
            r.get("user", user.toString());
            r.logic("getPersonalArena");
            r.whenCommitted("sendReply");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object my(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        TypeOf ty = (TypeOf)args[0];
        DataHandler handler = (DataHandler)args[1];
        ZiId simple = this.factory.simple("my", ((UOWHost)uow.trait(UOWHost.class)).host, ty.typeName(), ((ZiIdURI)zx.userIdentity()).unique().replace("/identity/", ""));
        logger.info("ZDS.my() called with " + ty + ": " + handler.getClass() + "; retrieving " + simple);
        Relation r = uow.relation((RelationHandler)new FetchMy(uow, simple, handler));
        try {
            r.get("currentMy", simple.toString());
            r.logic("checkIfMissing");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object putMy(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        ZinikiUOW zx = (ZinikiUOW)uow.trait(ZinikiUOW.class);
        if (zx == null) {
            throw new NotImplementedException("There is no ZX trait");
        }
        if (zx.userIdentity() == null) {
            throw new NotImplementedException("There is no identity in ZX trait");
        }
        ZiId user = zx.userIdentity();
        TypeOf ty = (TypeOf)args[0];
        IdempotentHandler handler = (IdempotentHandler)args[2];
        logger.info("ZDS.putMy() called with " + handler.getClass());
        FieldsContainerWrapper fcw = (FieldsContainerWrapper)args[1];
        String id = fcw.id();
        Relation r = uow.relation((RelationHandler)new PutMy(this.storage, zx, this.factory, uow, user, fcw, ty, id, handler));
        try {
            r.logic("createIfNew");
            r.whenCommitted("sendSuccessAndNotify");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object attachSecondaryIndex(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        IdempotentHandler ih = (IdempotentHandler)args[2];
        try {
            String aid;
            if (args[0] instanceof FieldsContainerWrapper) {
                aid = ((FieldsContainerWrapper)args[0]).id();
            } else if (args[0] instanceof String) {
                aid = (String)args[0];
            } else {
                ih.failure((EvalContext)cx, (Object)"not an arena");
                return null;
            }
            String keyName = args[1] instanceof String ? (String)args[1] : ((TypeOf)args[1]).typeName();
            Class<?> clz = Class.forName(keyName, false, this.loader);
            URIBuilder skuri = new URIBuilder(aid);
            skuri.setScheme("secidxcat");
            List ps = skuri.getPathSegments();
            ps.add(keyName);
            skuri.setPathSegments(ps);
            String catalogueName = skuri.build().toString();
            Relation r = uow.relation((RelationHandler)new AttachSecondaryIndex(cx, aid, clz, catalogueName, ih));
            r.get("arena", aid);
            r.get("catalogue", catalogueName);
            r.logic("checkNotPresent");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object attachSecondaryKeyset(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        IdempotentHandler ih = (IdempotentHandler)args[2];
        try {
            String aid;
            if (args[0] instanceof FieldsContainerWrapper) {
                aid = ((FieldsContainerWrapper)args[0]).id();
            } else if (args[0] instanceof String) {
                aid = (String)args[0];
            } else {
                ih.failure((EvalContext)cx, (Object)"not an arena");
                return null;
            }
            String keyName = args[1] instanceof String ? (String)args[1] : ((TypeOf)args[1]).typeName();
            Class<?> clz = Class.forName(keyName, false, this.loader);
            if (!Secondary.class.isAssignableFrom(clz)) {
                throw new InvalidUsageException(keyName + " is not a secondary definition");
            }
            URIBuilder skuri = new URIBuilder(aid);
            skuri.setScheme("seckeycat");
            List ps = skuri.getPathSegments();
            ps.add(keyName);
            skuri.setPathSegments(ps);
            String catalogueName = skuri.build().toString();
            Relation r = uow.relation((RelationHandler)new AttachSecondaryKeyset(cx, aid, clz, catalogueName, ih));
            r.get("arena", aid);
            r.get("catalogue", catalogueName);
            r.logic("checkNotPresent");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object secondaryIndex(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        CrobagUpdateHandler ch = (CrobagUpdateHandler)args[3];
        try {
            String aid;
            if (args[0] instanceof FieldsContainerWrapper) {
                aid = ((FieldsContainerWrapper)args[0]).id();
            } else if (args[0] instanceof String) {
                aid = (String)args[0];
            } else {
                ch.failure((EvalContext)cx, (Object)"not an arena");
                return null;
            }
            String keyName = args[1] instanceof String ? (String)args[1] : ((TypeOf)args[1]).typeName();
            List fields = (List)args[2];
            URIBuilder skuri = new URIBuilder(aid);
            skuri.setScheme("secidx");
            List ps = skuri.getPathSegments();
            ps.add(keyName);
            skuri.setPathSegments(ps);
            String catalogueName = skuri.build().toString();
            Relation r = uow.relation((RelationHandler)new GetSecondaryIndex(cx, this.nameProvider, catalogueName, fields, ch));
            r.logic("doGet");
            r.whenRolledBack("sendFailure");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object secondaryKey(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        DataHandler dh = (DataHandler)args[3];
        try {
            String aid;
            if (args[0] instanceof FieldsContainerWrapper) {
                aid = ((FieldsContainerWrapper)args[0]).id();
            } else if (args[0] instanceof String) {
                aid = (String)args[0];
            } else {
                dh.failure((EvalContext)cx, (Object)"not an arena");
                return null;
            }
            String keyName = args[1] instanceof String ? (String)args[1] : ((TypeOf)args[1]).typeName();
            Class<?> clz = Class.forName(keyName, false, this.loader);
            if (!this.hasInterface(clz, Secondary.class)) {
                throw new InvalidUsageException("cannot put to secondary that is not a Secondary");
            }
            List fieldNames = (List)Reflection.callStatic(clz, (String)"fieldNames", (Object[])new Object[]{cx});
            List fields = (List)args[2];
            URIBuilder skuri = new URIBuilder(aid);
            skuri.setScheme("seckey");
            List ps = skuri.getPathSegments();
            ps.add(keyName);
            skuri.setPathSegments(ps);
            String catalogueName = skuri.build().toString();
            Relation r = uow.relation((RelationHandler)new GetSecondaryKey(cx, this.nameProvider, catalogueName, fieldNames, fields, dh));
            r.logic("doGet");
            r.whenRolledBack("sendFailure");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public Object secondaryByType(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        DataHandler dh = (DataHandler)args[3];
        try {
            String aid;
            if (args[0] instanceof FieldsContainerWrapper) {
                aid = ((FieldsContainerWrapper)args[0]).id();
            } else if (args[0] instanceof String) {
                aid = (String)args[0];
            } else {
                dh.failure((EvalContext)cx, (Object)"not an arena");
                return null;
            }
            String keyName = args[1] instanceof String ? (String)args[1] : ((TypeOf)args[1]).typeName();
            Class<?> clz = Class.forName(keyName, false, this.loader);
            if (!this.hasInterface(clz, Secondary.class)) {
                throw new InvalidUsageException("cannot put to secondary that is not a secondary");
            }
            List fieldNames = (List)Reflection.callStatic(clz, (String)"fieldNames", (Object[])new Object[]{cx});
            TypeOf forType = (TypeOf)args[2];
            URIBuilder skuri = new URIBuilder(aid);
            skuri.setScheme("seckey");
            List ps = skuri.getPathSegments();
            ps.add(keyName);
            skuri.setPathSegments(ps);
            String catalogueName = skuri.build().toString();
            Relation r = uow.relation((RelationHandler)new GetSecondaryByType(cx, this.nameProvider, catalogueName, fieldNames, forType, dh));
            r.logic("doGet");
            r.whenRolledBack("sendFailure");
            r.makeReady();
        }
        catch (Throwable t) {
            uow.fatalError(t);
        }
        return null;
    }

    public void permissions(Relation r, String slot, ZiId user, String forId) {
    }

    private boolean hasInterface(Class<?> clz, Class<?> intf) {
        Class<?>[] intfs;
        for (Class<?> i : intfs = clz.getInterfaces()) {
            if (i != intf) continue;
            return true;
        }
        return false;
    }
}

