/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.lang.reflect.InvocationTargetException;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.DataHandler;
import org.ziniki.coreimpl.FailUOWHandler;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class SubscribeTo
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final TDAStorage storage;
    private final UnitOfWork uow;
    private final String simple;
    private final DataHandler handler;

    public SubscribeTo(TDAStorage storage, UnitOfWork uow, String simple, DataHandler handler) {
        this.storage = storage;
        this.uow = uow;
        this.simple = simple;
        this.handler = handler;
    }

    public void returnAndSubscribe(Relation r, @Slot(value="item") Object item) {
        this.storage.subscribe(this.uow, this.simple, (IdempotentHandler)this.handler);
        try {
            FLEvalContext cx = (FLEvalContext)this.uow;
            if (item != null) {
                this.handler.value(cx, new Object[]{SubscribeTo.translate(cx, item), new FailUOWHandler(this.uow)});
            }
        }
        catch (Exception ex) {
            logger.error("failed to send subscription value", (Throwable)ex);
        }
    }

    public static Object translate(FLEvalContext cx, Object item) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        FieldsContainerWrapper fcw;
        String clz;
        if (item instanceof FieldsContainerWrapper && (clz = (String)(fcw = (FieldsContainerWrapper)item).get("_projection")) != null) {
            Class<?> ac = Class.forName(clz, false, cx.getLoader());
            FieldsContainerWrapper ret = (FieldsContainerWrapper)ac.getConstructor(FLEvalContext.class).newInstance(cx);
            ret.set("_id", (Object)fcw.id());
            return ret;
        }
        return item;
    }
}

