/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.util.TreeMap;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.TypeOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.MyRecord;
import org.ziniki.common.UOWHost;
import org.ziniki.common.ZiIdURI;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.intf.ZinikiUOW;
import org.ziniki.services.datastore.NotifyDataHandlerSubscriber;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class PutMy
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final TDAStorage storage;
    private final ZinikiUOW zx;
    private final ZiIdFactory factory;
    private final UnitOfWork uow;
    private final ZiId user;
    private final FieldsContainerWrapper entity;
    private final TypeOf ty;
    private String id;
    private final IdempotentHandler handler;

    public PutMy(TDAStorage storage, ZinikiUOW zx, ZiIdFactory factory, UnitOfWork uow, ZiId user, FieldsContainerWrapper entity, TypeOf ty, String id, IdempotentHandler handler) {
        this.storage = storage;
        this.zx = zx;
        this.factory = factory;
        this.uow = uow;
        this.user = user;
        this.entity = entity;
        this.ty = ty;
        this.id = id;
        this.handler = handler;
    }

    public void createIfNew(Relation r) {
        ZiId myid = this.factory.simple("my", ((UOWHost)this.uow.trait(UOWHost.class)).host, this.ty.typeName(), ((ZiIdURI)this.zx.userIdentity()).unique().replace("/identity/", ""));
        if (this.id == null) {
            ZiId ziid = this.factory.nextInSequence("data", ((UOWHost)this.uow.trait(UOWHost.class)).host, "entity");
            this.id = ziid.toString();
            TreeMap<String, String> sec = new TreeMap<String, String>();
            sec.put("ownedBy", this.user.toString());
            sec.put("securedBy", (String)myid);
            this.entity.set("_security", sec);
            logger.info("creating new entity " + this.id + " in putMy");
            r.create(this.id, (Object)this.entity);
        }
        MyRecord obj = new MyRecord((FLEvalContext)this.uow);
        obj.set("pointsTo", (Object)this.id);
        r.upsert(myid.toString(), (Object)obj);
        r.load("myaddr", (Object)myid.toString());
    }

    public void sendSuccessAndNotify(@Slot(value="myaddr") String myaddr) {
        this.handler.success((EvalContext)this.uow);
        this.storage.notifySubscribers(this.uow, myaddr, (NotifySubscriber)new NotifyDataHandlerSubscriber(this.entity));
    }
}

