/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.concepts.SecondaryKeyEntry;
import org.ziniki.core.fl.EntityOnBench;
import org.ziniki.core.fl.SecondaryInArena;
import org.ziniki.intf.ZiId;
import org.ziniki.services.datastore.NotifyDataHandlerSubscriber;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.zinutils.exceptions.NotImplementedException;

public class PutEntity
implements RelationHandler {
    public final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final FLEvalContext cx;
    private final UnitOfWork uow;
    private final String eid;
    private final FieldsContainerWrapper entity;
    private final IdempotentHandler handler;
    private final List<ZiId> toNotify = new ArrayList<ZiId>();

    public PutEntity(FLEvalContext cx, UnitOfWork uow, String eid, FieldsContainerWrapper e, IdempotentHandler ih) {
        this.cx = cx;
        this.uow = uow;
        this.eid = eid;
        this.entity = e;
        this.handler = ih;
    }

    public void findSecondaries(Relation r, @Slot(value="benches") List<EntityOnBench> benches) {
        ArrayList<CallSite> arenas = new ArrayList<CallSite>();
        for (EntityOnBench b : benches) {
            System.out.println("fetching for arena " + b.arenaId());
            String sid = "arena_" + b.arenaId();
            arenas.add((CallSite)((Object)sid));
            r.links(sid, "SecondaryInArena", b.arenaId());
        }
        r.map("arenas", arenas);
    }

    public void checkSecondaries(Relation r, @Slot(value="arenas") Map<String, List<SecondaryInArena>> arenas) {
        ArrayList<SecondaryInArena> bytype = new ArrayList<SecondaryInArena>();
        ArrayList fortype = new ArrayList();
        ArrayList<CallSite> secondaries = new ArrayList<CallSite>();
        for (List<SecondaryInArena> lsa : arenas.values()) {
            for (SecondaryInArena o : lsa) {
                if (o.bytype) {
                    bytype.add(o);
                    String uri = ZiIdURI.fromString((String)o.range()).makeScheme("seckey").append(this.entity.getClass().getName()).toString();
                    String id = "secondary_" + uri;
                    r.get(id, uri);
                    secondaries.add((CallSite)((Object)id));
                    continue;
                }
                throw new NotImplementedException("need to check entity type matches");
            }
        }
        r.map("secondaries", secondaries);
    }

    public void putRecord(Relation r, @Slot(value="secondaries") Map<String, SecondaryKeyEntry> secondaries, @Slot(value="current") Object current) {
        if (current == null) {
            this.uow.fatalError((Throwable)new RuntimeException("Record " + this.eid + " was not found to be updated"));
            return;
        }
        if (secondaries == null) {
            this.uow.fatalError((Throwable)new RuntimeException("Secondaries were not found"));
            return;
        }
        FieldsContainerWrapper fcw = (FieldsContainerWrapper)current;
        Object sr = fcw.get("_security");
        if (sr == null) {
            this.uow.fatalError((Throwable)new RuntimeException("Record " + this.eid + " did not have a security entry"));
            return;
        }
        for (SecondaryKeyEntry ske : secondaries.values()) {
            if (!ske.pointsTo().toString().equals(this.eid)) {
                this.uow.fatalError((Throwable)new RuntimeException("secondary key conflict: " + ske.ziid()));
                return;
            }
            this.toNotify.add(ske.ziid());
        }
        this.entity.set("_security", sr);
        r.update(this.eid, (Object)this.entity);
    }

    public void sendHappyResponse(Relation r) {
        this.handler.success((EvalContext)this.cx);
        try {
            r.sendNotifications(this.eid, (NotifySubscriber)new NotifyDataHandlerSubscriber(this.entity));
        }
        catch (Throwable e) {
            this.logger.error("error sending put notification on " + this.eid, e);
        }
        this.logger.error("toNotify = " + this.toNotify);
        for (ZiId z : this.toNotify) {
            try {
                r.sendNotifications(z.toString(), (NotifySubscriber)new NotifyDataHandlerSubscriber(this.entity));
            }
            catch (Throwable e) {
                this.logger.error("error sending put notification on " + z, e);
            }
        }
    }

    public void sendFailureResponse(TxError err) {
        this.handler.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

