/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.common.UOWHost;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Bench;
import org.ziniki.core.fl.IdentityOnBench;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class JoinArena
implements RelationHandler {
    public final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final FLEvalContext cx;
    private final UnitOfWork uow;
    private final ZiIdFactory factory;
    private final String bench;
    private final ZiId identity;
    private final FieldsContainerWrapper persona;
    private final IdempotentHandler handler;

    public JoinArena(FLEvalContext cx, UnitOfWork uow, ZiIdFactory factory, String bench, ZiId identity, FieldsContainerWrapper persona, IdempotentHandler handler) {
        this.cx = cx;
        this.uow = uow;
        this.factory = factory;
        this.bench = bench;
        this.identity = identity;
        this.persona = persona;
        this.handler = handler;
    }

    public void joinArena(Relation r, @Slot(value="arena") Arena arena) {
        if (arena == null) {
            this.uow.fatalError((Throwable)new RuntimeException("the arena was not found"));
            return;
        }
        Bench b = arena.bench(this.bench);
        if (b == null) {
            this.uow.fatalError((Throwable)new RuntimeException("there is no bench " + this.bench + " in " + arena.ziid()));
            return;
        }
        ZiId pid = this.factory.nextInSequence("ziniki", ((UOWHost)this.uow.trait(UOWHost.class)).host, "persona");
        r.create(pid.toString(), (Object)this.persona);
        r.link((EntityLink)new IdentityOnBench(this.identity, b.ziid(), pid));
    }

    public void sendHappyResponse() {
        this.handler.success((EvalContext)this.cx);
    }

    public void sendFailureResponse(TxError err) {
        this.handler.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

