/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Crobag;
import org.flasck.jvm.container.ResponseWithMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.CrobagUpdateHandler;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.core.fl.CrobagEntry;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.jvm.LoggingIdempotentHandler;

public class GetSecondaryIndex
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final FLEvalContext cx;
    private final String catalogueName;
    private final List<String> fields;
    private final CrobagUpdateHandler ch;
    private String key;

    public GetSecondaryIndex(FLEvalContext cx, HandlerNameProvider nameProvider, String catalogueName, List<String> fields, CrobagUpdateHandler ch) {
        this.cx = cx;
        this.catalogueName = catalogueName;
        this.fields = fields;
        this.ch = ch;
    }

    public void doGet(Relation r) throws GLSException {
        logger.info("get secondary key");
        this.key = this.catalogueName;
        try {
            for (String s : this.fields) {
                if (s == null || s.length() == 0) {
                    this.ch.failure((EvalContext)this.cx, (Object)"invalid key field");
                    return;
                }
                this.key = this.key + "/" + URLEncoder.encode(s, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            this.ch.failure((EvalContext)this.cx, (Object)e.toString());
        }
        r.links("entries", "Crobags", this.key);
        r.logic("determineOutcome");
        r.subscribe(this.key, (IdempotentHandler)this.ch);
    }

    public void determineOutcome(Relation r, @Slot(value="entries") ArrayList<CrobagEntry> entries) throws GLSException {
        ResponseWithMessages rwm = (ResponseWithMessages)Crobag._ctor_new((FLEvalContext)this.cx, (Object[])new Object[]{null});
        Crobag cb = (Crobag)ResponseWithMessages.response((FLEvalContext)this.cx, (Object)rwm);
        cb.set("_id", (Object)this.key);
        if (entries != null) {
            for (CrobagEntry e : entries) {
                cb._change(this.cx, "put", e.range(), null, (Object)e.entity());
            }
        }
        r.load("crobag", (Object)cb);
        r.logic("sendValue");
    }

    public void sendValue(@Slot(value="crobag") Object crobag) {
        this.ch.present(this.cx, new Object[]{crobag, new LoggingIdempotentHandler()});
        this.ch.success((EvalContext)this.cx);
    }

    public void sendFailure(TxError err) {
        this.ch.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

