/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.analytics;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpResponse;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.analytics.GenericAnalyticsResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

public class GenericAnalyticsRequest
extends BaseRequest<GenericAnalyticsResponse>
implements NonChunkedHttpRequest<GenericAnalyticsResponse> {
    private final Supplier<FullHttpRequest> requestSupplier;
    private final boolean idempotent;

    public GenericAnalyticsRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Supplier<FullHttpRequest> requestSupplier, boolean idempotent) {
        super(timeout, ctx, retryStrategy);
        this.requestSupplier = Objects.requireNonNull(requestSupplier);
        this.idempotent = idempotent;
    }

    @Override
    public GenericAnalyticsResponse decode(FullHttpResponse response, HttpChannelContext context) {
        byte[] dst = new byte[response.content().readableBytes()];
        response.content().readBytes(dst);
        return new GenericAnalyticsResponse(HttpProtocol.decodeStatus(response.status()), dst);
    }

    @Override
    public FullHttpRequest encode() {
        FullHttpRequest request = this.requestSupplier.get();
        this.context().authenticator().authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.ANALYTICS;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }
}

