/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.io.ReadTrafficCapturedEvent;
import com.couchbase.client.core.cnc.events.io.WriteTrafficCapturedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.IoContext;

public class TrafficCaptureHandler
extends ChannelDuplexHandler {
    private final EndpointContext endpointContext;
    private final EventBus eventBus;
    private IoContext ioContext;

    public TrafficCaptureHandler(EndpointContext endpointContext) {
        this.endpointContext = endpointContext;
        this.eventBus = endpointContext.environment().eventBus();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        ctx.fireChannelActive();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            this.eventBus.publish(new ReadTrafficCapturedEvent(this.ioContext, ByteBufUtil.prettyHexDump((ByteBuf)msg)));
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            this.eventBus.publish(new WriteTrafficCapturedEvent(this.ioContext, ByteBufUtil.prettyHexDump((ByteBuf)msg)));
        }
        ctx.write(msg, promise);
    }
}

