/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.handler.ssl.OpenSsl;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslContextBuilder;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslProvider;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.SecurityConfig;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class SslHandlerFactory {
    private static final boolean OPENSSL_AVAILABLE = OpenSsl.isAvailable();

    public static SslHandler get(ByteBufAllocator allocator, SecurityConfig config, Authenticator authenticator) throws Exception {
        SslProvider provider = OPENSSL_AVAILABLE && config.nativeTlsEnabled() ? SslProvider.OPENSSL : SslProvider.JDK;
        SslContextBuilder context = SslContextBuilder.forClient().sslProvider(provider);
        if (config.trustManagerFactory() != null) {
            context.trustManager(config.trustManagerFactory());
        } else if (config.trustCertificates() != null && !config.trustCertificates().isEmpty()) {
            context.trustManager(config.trustCertificates().toArray(new X509Certificate[0]));
        }
        authenticator.applyTlsProperties(context);
        SslHandler sslHandler = context.build().newHandler(allocator);
        SSLEngine sslEngine = sslHandler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
        return sslHandler;
    }
}

