/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.io.netty.NonChunkedHttpMessageHandler;
import com.couchbase.client.core.io.netty.chunk.ChunkedMessageHandler;
import com.couchbase.client.core.msg.Request;

public class ChunkedHandlerSwitcher
extends ChannelDuplexHandler {
    public static final String SWITCHER_IDENTIFIER = ChunkedHandlerSwitcher.class.getSimpleName();
    private static final String CHUNKED_IDENTIFIER = ChunkedMessageHandler.class.getSimpleName();
    private final ChunkedMessageHandler chunkedHandler;
    private final NonChunkedHttpMessageHandler nonChunkedHandler;
    private final Class<? extends Request> chunkedClass;
    private boolean chunkedHandlerActive = false;

    protected ChunkedHandlerSwitcher(ChunkedMessageHandler chunkedHandler, NonChunkedHttpMessageHandler nonChunkedHandler, Class<? extends Request> chunkedClass) {
        this.chunkedHandler = chunkedHandler;
        this.nonChunkedHandler = nonChunkedHandler;
        this.chunkedClass = chunkedClass;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.activateChunkedHandler(ctx);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        boolean isChunked = this.chunkedClass.isAssignableFrom(msg.getClass());
        if (isChunked && !this.chunkedHandlerActive) {
            this.deactivateNonChunkedHandler(ctx);
            this.activateChunkedHandler(ctx);
        } else if (!isChunked && this.chunkedHandlerActive) {
            this.deactivateChunkedHandler(ctx);
            this.activateNonChunkedHandler(ctx);
        }
        ctx.write(msg, promise);
    }

    private void activateChunkedHandler(ChannelHandlerContext ctx) {
        ctx.pipeline().addBefore(SWITCHER_IDENTIFIER, CHUNKED_IDENTIFIER, this.chunkedHandler);
        this.chunkedHandler.channelActive(ctx);
        this.chunkedHandlerActive = true;
    }

    private void deactivateChunkedHandler(ChannelHandlerContext ctx) {
        ctx.pipeline().remove(CHUNKED_IDENTIFIER);
        this.chunkedHandlerActive = false;
    }

    private void activateNonChunkedHandler(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(SWITCHER_IDENTIFIER, NonChunkedHttpMessageHandler.IDENTIFIER, this.nonChunkedHandler);
        this.nonChunkedHandler.channelActive(ctx);
    }

    private void deactivateNonChunkedHandler(ChannelHandlerContext ctx) {
        ctx.pipeline().remove(NonChunkedHttpMessageHandler.IDENTIFIER);
    }
}

