/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.BuilderPropertySetter;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.util.Properties;
import java.util.function.BiConsumer;

public class SystemPropertyPropertyLoader
implements PropertyLoader<CoreEnvironment.Builder> {
    private static final String PREFIX = "com.couchbase.env.";
    private final BuilderPropertySetter setter = new BuilderPropertySetter();
    private final Properties properties;

    public SystemPropertyPropertyLoader() {
        this(System.getProperties());
    }

    public SystemPropertyPropertyLoader(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void load(CoreEnvironment.Builder builder) {
        this.forEachStringProperty((name, value) -> {
            if (name.startsWith(PREFIX)) {
                try {
                    this.setter.set(builder, name.substring(PREFIX.length()), (String)value);
                }
                catch (IllegalArgumentException e) {
                    throw InvalidArgumentException.fromMessage("Failed to apply system property \"" + name + "\". " + e.getMessage(), e);
                }
            }
        });
    }

    private void forEachStringProperty(BiConsumer<String, String> action) {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key instanceof String && value instanceof String) {
                action.accept((String)key, (String)value);
            }
        }));
    }
}

