/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.service.ServiceType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortInfo {
    private final Map<ServiceType, Integer> ports;
    private final Map<ServiceType, Integer> sslPorts;
    private final Map<String, AlternateAddress> alternateAddresses;
    private final String hostname;

    @JsonCreator
    public PortInfo(@JsonProperty(value="services") Map<String, Integer> services, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="alternateAddresses") Map<String, AlternateAddress> aa) {
        this.ports = new HashMap<ServiceType, Integer>();
        this.sslPorts = new HashMap<ServiceType, Integer>();
        this.alternateAddresses = aa == null ? Collections.emptyMap() : aa;
        this.hostname = hostname;
        PortInfo.extractPorts(services, this.ports, this.sslPorts);
    }

    PortInfo(Map<ServiceType, Integer> ports, Map<ServiceType, Integer> sslPorts, Map<String, AlternateAddress> alternateAddresses, String hostname) {
        this.ports = Objects.requireNonNull(ports);
        this.sslPorts = Objects.requireNonNull(sslPorts);
        this.alternateAddresses = Objects.requireNonNull(alternateAddresses);
        this.hostname = Objects.requireNonNull(hostname);
    }

    public NodeIdentifier identifier() {
        return new NodeIdentifier(this.hostname, this.ports.get((Object)ServiceType.MANAGER));
    }

    static void extractPorts(Map<String, Integer> input, Map<ServiceType, Integer> ports, Map<ServiceType, Integer> sslPorts) {
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            String service = entry.getKey();
            int port = entry.getValue();
            switch (service) {
                case "mgmt": {
                    ports.put(ServiceType.MANAGER, port);
                    break;
                }
                case "capi": {
                    ports.put(ServiceType.VIEWS, port);
                    break;
                }
                case "kv": {
                    ports.put(ServiceType.KV, port);
                    break;
                }
                case "kvSSL": {
                    sslPorts.put(ServiceType.KV, port);
                    break;
                }
                case "capiSSL": {
                    sslPorts.put(ServiceType.VIEWS, port);
                    break;
                }
                case "mgmtSSL": {
                    sslPorts.put(ServiceType.MANAGER, port);
                    break;
                }
                case "n1ql": {
                    ports.put(ServiceType.QUERY, port);
                    break;
                }
                case "n1qlSSL": {
                    sslPorts.put(ServiceType.QUERY, port);
                    break;
                }
                case "fts": {
                    ports.put(ServiceType.SEARCH, port);
                    break;
                }
                case "ftsSSL": {
                    sslPorts.put(ServiceType.SEARCH, port);
                    break;
                }
                case "cbas": {
                    ports.put(ServiceType.ANALYTICS, port);
                    break;
                }
                case "cbasSSL": {
                    sslPorts.put(ServiceType.ANALYTICS, port);
                }
            }
        }
    }

    public Map<ServiceType, Integer> ports() {
        return this.ports;
    }

    public Map<ServiceType, Integer> sslPorts() {
        return this.sslPorts;
    }

    public String hostname() {
        return this.hostname;
    }

    public Map<String, AlternateAddress> alternateAddresses() {
        return this.alternateAddresses;
    }

    public String toString() {
        return "PortInfo{ports=" + this.ports + ", sslPorts=" + this.sslPorts + ", hostname='" + this.hostname + ", alternateAddresses=" + this.alternateAddresses + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortInfo portInfo = (PortInfo)o;
        if (this.ports != null ? !this.ports.equals(portInfo.ports) : portInfo.ports != null) {
            return false;
        }
        if (this.sslPorts != null ? !this.sslPorts.equals(portInfo.sslPorts) : portInfo.sslPorts != null) {
            return false;
        }
        if (this.alternateAddresses != null ? !this.alternateAddresses.equals(portInfo.alternateAddresses) : portInfo.alternateAddresses != null) {
            return false;
        }
        return this.hostname != null ? this.hostname.equals(portInfo.hostname) : portInfo.hostname == null;
    }

    public int hashCode() {
        int result = this.ports != null ? this.ports.hashCode() : 0;
        result = 31 * result + (this.sslPorts != null ? this.sslPorts.hashCode() : 0);
        result = 31 * result + (this.alternateAddresses != null ? this.alternateAddresses.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        return result;
    }
}

