/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JacksonInject;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.service.ServiceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GlobalConfig {
    private final long rev;
    private final List<PortInfo> portInfos;
    private final Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities;

    @JsonCreator
    public GlobalConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="clusterCapabilities") Map<String, Set<ClusterCapabilities>> clusterCapabilities, @JacksonInject(value="origin") String origin) {
        this.rev = rev;
        this.portInfos = this.enrichPortInfos(portInfos, origin);
        this.clusterCapabilities = AbstractBucketConfig.convertClusterCapabilities(clusterCapabilities);
    }

    private List<PortInfo> enrichPortInfos(List<PortInfo> portInfos, String origin) {
        ArrayList<PortInfo> enriched = new ArrayList<PortInfo>(portInfos.size());
        for (PortInfo portInfo : portInfos) {
            if (portInfo.hostname() == null) {
                enriched.add(new PortInfo(portInfo.ports(), portInfo.sslPorts(), portInfo.alternateAddresses(), origin));
                continue;
            }
            enriched.add(portInfo);
        }
        return enriched;
    }

    public long rev() {
        return this.rev;
    }

    public Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities() {
        return this.clusterCapabilities;
    }

    public List<PortInfo> portInfos() {
        return this.portInfos;
    }

    public String toString() {
        return "GlobalConfig{rev=" + this.rev + ", portInfos=" + this.portInfos + ", clusterCapabilities=" + this.clusterCapabilities + '}';
    }
}

