/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.grizzly.chrome;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.ziniki.server.CentralServerStore;
import org.ziniki.server.NewConnectionHandler;
import org.ziniki.server.di.MakeAHandler;
import org.ziniki.server.grizzly.GrizzlyTDAServer;
import org.ziniki.server.grizzly.GrizzlyTDAWebSocketHandler;
import org.ziniki.server.main.grizzly.chrome.ChromeJSJavaBridge;
import org.ziniki.server.main.grizzly.chrome.ChromeZiwshGrizzlyListener;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.path.SimplePathTree;
import org.ziniki.server.tda.Transport;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.servlet.tda.TDAConfiguration;
import org.ziniki.ziwsh.intf.WSProcessor;

public class ChromeTestRunner {
    private static final int zinikiPort = 18080;
    private final GrizzlyTDAServer zinikiServer = this.configureZinikiServer();
    private ChromeZiwshGrizzlyListener ziwsh;
    private ChromeJSJavaBridge bridge;

    public static void main(String[] args) throws Exception {
        new ChromeTestRunner().run();
    }

    private GrizzlyTDAServer configureZinikiServer() {
        GrizzlyTDAServer server = new GrizzlyTDAServer(18080);
        SimplePathTree tree = new SimplePathTree();
        tree.add("/wsapi/{token}/{secret}", (MakeAHandler)new MakeAHandler<WSProcessor>(){

            public WSProcessor instantiate(TDAConfiguration config) throws Exception {
                ChromeTestRunner.this.ziwsh = new ChromeZiwshGrizzlyListener();
                if (ChromeTestRunner.this.bridge != null) {
                    ChromeTestRunner.this.ziwsh.bridge(ChromeTestRunner.this.bridge);
                    ChromeTestRunner.this.bridge.ziwsh(ChromeTestRunner.this.ziwsh);
                }
                return ChromeTestRunner.this.ziwsh;
            }
        });
        tree.add("/bridge", (MakeAHandler)new MakeAHandler<WSProcessor>(){

            public WSProcessor instantiate(TDAConfiguration config) throws Exception {
                ChromeTestRunner.this.bridge = new ChromeJSJavaBridge(ChromeTestRunner.class.getClassLoader(), new File("."));
                if (ChromeTestRunner.this.ziwsh != null) {
                    ChromeTestRunner.this.ziwsh.bridge(ChromeTestRunner.this.bridge);
                    ChromeTestRunner.this.bridge.ziwsh(ChromeTestRunner.this.ziwsh);
                }
                return ChromeTestRunner.this.bridge;
            }
        });
        NewConnectionHandler<WSReceiver> handler = new NewConnectionHandler<WSReceiver>(){

            public void newConnection(Transport transport, WSReceiver handler) {
                transport.addReceiver(handler);
            }
        };
        server.wsMappingTree((CentralServerStore)new GrizzlyTDAWebSocketHandler(), (PathTree)tree, (NewConnectionHandler)handler);
        return server;
    }

    private void run() throws Exception {
        this.zinikiServer.start();
        CountDownLatch cdl = new CountDownLatch(1);
        cdl.await();
    }
}

