/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.grizzly;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeSet;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.CentralServerStore;
import org.ziniki.server.di.DehydratedHandler;
import org.ziniki.server.grizzly.GrizzlyTDAServer;
import org.ziniki.server.main.ZinikiStreams;
import org.ziniki.server.main.config.ZinikiServerMappings;
import org.ziniki.server.main.config.ZinikiTDAServer;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.path.SimplePathTree;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.zinutils.inabox.grizzly.actors.GrizzlyBuilder;
import org.zinutils.streamedlogger.api.LabelBinder;

public class ZinikiGrizzlyServer
implements ZinikiTDAServer {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTDAServer");
    private final String myName;
    private final ZinikiStreams streamer;
    private final CentralServerStore central;
    private final int port;
    private final ZinikiServerMappings mappings;
    private final String keystore;
    private final String kspasswd;
    private GrizzlyTDAServer server;

    public ZinikiGrizzlyServer(@Param(value="instantiatableName") String myName, @Param(value="streamer") ZinikiStreams streamer, @Param(value="central") CentralServerStore central, @Param(value="port") int port, @Param(value="mappings") ZinikiServerMappings mappings) {
        this(myName, streamer, central, port, mappings, null, null, null);
    }

    public ZinikiGrizzlyServer(@Param(value="instantiatableName") String myName, @Param(value="streamer") ZinikiStreams streamer, @Param(value="central") CentralServerStore central, @Param(value="port") int port, @Param(value="mappings") ZinikiServerMappings mappings, @Param(value="root") File rootdir, @Param(value="keystore") String keystore, @Param(value="kspassword") String kspasswd) {
        this.myName = myName;
        this.streamer = streamer;
        this.central = central;
        this.port = port;
        this.mappings = mappings;
        this.keystore = rootdir == null || new File(keystore).exists() ? keystore : new File(rootdir, keystore).getPath();
        this.kspasswd = kspasswd;
    }

    @Override
    public void configure(TreeSet<String> errors, Map<String, DehydratedHandler<?>> processors) throws Exception {
        SSLEngineConfigurator grizzly = this.keystore == null || this.keystore.length() == 0 ? GrizzlyBuilder.selfServingSSL() : GrizzlyBuilder.initializeSSL((String)this.keystore, (String)this.kspasswd);
        this.server = new GrizzlyTDAServer(grizzly, this.port, (LabelBinder)this.streamer, this.myName);
        SimplePathTree http = new SimplePathTree();
        SimplePathTree ws = new SimplePathTree();
        logger.info("Configuring mappings for port " + this.port);
        this.mappings.processMappings(errors, processors, (PathTree<RequestProcessor>)http, (PathTree<WSProcessor>)ws);
        this.server.httpMappingTree((PathTree)http);
        logger.info("Configuring port " + this.port + " to have WS mappings " + (PathTree)ws);
        this.server.wsMappingTree(this.central, (PathTree)ws, (t, h) -> t.addReceiver(h));
    }

    public void start() throws IOException {
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public String toString() {
        return "ZinikiGrizzlyServer[" + this.myName + "]";
    }
}

