/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.config;

import java.util.Map;
import java.util.TreeSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.di.DehydratedHandler;
import org.ziniki.server.di.ReferenceExtractor;
import org.ziniki.server.path.PathTree;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSProcessor;

public class ZinikiServerMappings {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTDAServer");
    private final JSONArray mappings;

    public ZinikiServerMappings(@Param(value="mappings") JSONArray mappings) {
        this.mappings = mappings;
    }

    public void processMappings(TreeSet<String> errors, Map<String, DehydratedHandler<?>> processors, PathTree<RequestProcessor> http, PathTree<WSProcessor> ws) throws JSONException {
        for (int i = 0; i < this.mappings.length(); ++i) {
            ReferenceExtractor handler;
            JSONObject jo = this.mappings.getJSONObject(i);
            String path = jo.getString("path");
            try {
                handler = new ReferenceExtractor(jo.getString("handler"));
            }
            catch (Exception ex) {
                errors.add("Defining handler for " + path + ": " + ex.getMessage());
                continue;
            }
            DehydratedHandler<?> dh = processors.get(handler.actualName());
            if (dh == null) {
                errors.add("There is no handler " + handler.actualName() + " defined (path: " + path + ")");
                continue;
            }
            if (dh.isWS()) {
                logger.info("Adding path " + path + " to WS");
                ws.add(path, dh);
                continue;
            }
            logger.info("Adding path " + path + " to HTTP");
            http.add(path, dh);
        }
    }

    public String toString() {
        return "Mappings" + this.mappings;
    }
}

