/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.config;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.CodePackage;
import org.ziniki.CodePackageVersion;
import org.ziniki.core.fl.JVMSecondaryKeyEntry;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.secondaries.PackageByName;
import org.ziniki.secondaries.PackageByNameVersion;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;

public class InitializationLogic
implements RelationHandler {
    private final ZiIdFactory factory;
    private final IMContentStorage cs;
    private final FLEvalContext cx;
    private final String domain;
    private final ZiId aid;

    public InitializationLogic(ZiIdFactory factory, IMContentStorage cs, FLEvalContext cx, String domain, ZiId aid) {
        this.factory = factory;
        this.cs = cs;
        this.cx = cx;
        this.domain = domain;
        this.aid = aid;
    }

    public CPP createPackageVersion(Relation r, String pkg, String version, ArrayList<Object> deps) throws URISyntaxException {
        String cpid = this.factory.nextInSequence("data", this.domain, "entity").toString();
        CodePackage cp = (CodePackage)CodePackage.eval((FLEvalContext)this.cx, (Object[])new Object[]{pkg, version});
        r.create(cpid, (Object)cp);
        r.upsert(this.seckey(this.aid.toString(), PackageByName.class.getName()) + "/" + pkg, (Object)new JVMSecondaryKeyEntry(this.cx, cpid));
        String cpvid = this.factory.nextInSequence("data", this.domain, "entity").toString();
        CodePackageVersion cpv = (CodePackageVersion)CodePackageVersion.eval((FLEvalContext)this.cx, (Object[])new Object[]{pkg, version, deps});
        cpv.set("deployed", (Object)true);
        r.create(cpvid, (Object)cpv);
        r.upsert(this.seckey(this.aid.toString(), PackageByNameVersion.class.getName()) + "/" + pkg + "/" + version, (Object)new JVMSecondaryKeyEntry(this.cx, cpvid));
        return new CPP(cp, cpv);
    }

    public void attach(String name, CodePackageVersion cpv, File dir, String[] flascklive, String[] flascktest) {
        this.uploadMany(name, cpv, dir, flascklive, (List)cpv._field_livejs(this.cx, new Object[0]));
        this.uploadMany(name, cpv, dir, flascktest, (List)cpv._field_testjs(this.cx, new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    private void uploadMany(String pkg, CodePackageVersion cpv, File dir, String[] files, List<Object> cos) {
        for (String string : files) {
            void var9_9;
            if (!string.endsWith(".js")) {
                String string2 = string + ".js";
            }
            this.upload("js", pkg, cpv, dir, (String)var9_9, cos, "text/javascript");
        }
    }

    public void upload(String type, String pkg, CodePackageVersion cpv, File dir, String file, List<Object> cos, String ct) {
        Object version = cpv._field_version(this.cx, new Object[0]);
        ContentObject co = this.cs.upload("packages/" + type + "/" + pkg + "/" + version + "/" + file, new File(dir, file), ct);
        cos.add(co);
    }

    public String seckey(String aid, String keyName) throws URISyntaxException {
        URIBuilder skuri = new URIBuilder(aid);
        skuri.setScheme("seckey");
        List ps = skuri.getPathSegments();
        ps.add(keyName);
        skuri.setPathSegments(ps);
        return skuri.build().toString();
    }

    public class CPP {
        CodePackage cp;
        CodePackageVersion cpv;

        public CPP(CodePackage cp, CodePackageVersion cpv) {
            this.cp = cp;
            this.cpv = cpv;
        }
    }
}

