/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.jettison.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.AWSTxManager;
import org.ziniki.server.main.ZinikiStreams;
import org.ziniki.server.main.config.ConfigurationOptions;
import org.ziniki.server.main.config.S3Reader;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.path.SimplePathTree;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.TDAConfiguration;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.zinutils.streamedlogger.StreamedLoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class AWSTDAServer
implements TDAConfiguration,
S3Reader {
    protected final Logger logger;
    private Throwable captureEx;
    private PathTree<RequestProcessor> httpMappingTree;
    private PathTree<WSProcessor> webSocketMappingTree;
    private S3Client s3;
    private String bucket;
    private Set<AWSTxManager> mgrs;

    public static void main(String[] args) throws Throwable {
        ProfileCredentialsProvider provider = ProfileCredentialsProvider.builder().profileName("ziniki").build();
        AWSTDAServer server = new AWSTDAServer((AwsCredentialsProvider)provider);
        if (server.captureEx != null) {
            throw server.captureEx;
        }
    }

    public AWSTDAServer(AwsCredentialsProvider creds) {
        ZinikiStreams streamer = new ZinikiStreams();
        Properties props = new Properties();
        props.setProperty("streamlogger.levelOf.DI", "WARN");
        props.setProperty("streamlogger.defaultLevel", "INFO");
        StreamedLoggerFactory.init((Properties)props, (Callable)streamer);
        this.logger = LoggerFactory.getLogger((String)"tdaserver");
        this.logger.info("In config");
        try {
            this.bucket = System.getenv("CONFIG_BUCKET");
            if (this.bucket == null) {
                throw new RuntimeException("Must specify CONFIG_BUCKET");
            }
            String args = System.getenv("CONFIG_ARGS_KEY");
            if (args == null) {
                throw new RuntimeException("Must specify CONFIG_ARGS_KEY");
            }
            String stage = System.getenv("CONFIG_STAGE");
            if (stage == null) {
                throw new RuntimeException("Must specify CONFIG_STAGE");
            }
            String useMappings = System.getenv("CONFIG_USE_MAPPINGS");
            if (useMappings == null) {
                throw new RuntimeException("Must specify CONFIG_USE_MAPPINGS");
            }
            this.logger.info("Bucket = " + this.bucket + " key = " + args + " stage = " + stage + " mappings = " + useMappings);
            this.s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(creds)).region(Region.US_EAST_1)).build();
            String str = this.read(args);
            JSONArray ja = new JSONArray(str);
            String[] arr = new String[ja.length() + 4];
            arr[0] = "--s3Config";
            arr[1] = stage + ".json";
            arr[2] = "--s3Config";
            arr[3] = "aws-" + stage + ".json";
            for (int i = 0; i < ja.length(); ++i) {
                arr[i + 4] = ja.getString(i);
            }
            this.httpMappingTree = new SimplePathTree();
            this.webSocketMappingTree = new SimplePathTree();
            ConfigurationOptions config = new ConfigurationOptions(this, arr);
            config.bind("streamer", streamer);
            config.bind("appLoader", this.getClass().getClassLoader());
            config.doConfiguration();
            config.getMappings(useMappings, this.httpMappingTree, this.webSocketMappingTree);
            this.mgrs = config.getItemsOfClass(AWSTxManager.class);
            this.logger.info("bound txmgr to " + this.mgrs);
        }
        catch (Throwable t) {
            this.captureEx = t;
        }
    }

    public Throwable initializationException() {
        return this.captureEx;
    }

    @Override
    public String read(String key) throws IOException {
        GetObjectRequest req = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(key).build();
        this.logger.info("Reading " + this.bucket + ":" + key);
        try {
            byte[] reader = ((ResponseBytes)this.s3.getObject(req, ResponseTransformer.toBytes())).asByteArray();
            return new String(reader, "UTF-8");
        }
        catch (NoSuchKeyException ex) {
            this.logger.error("cannot read " + key);
            return "";
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error("No UTF-8", (Throwable)ex);
            return "";
        }
    }

    public RequestProcessor makeHTTPHandler(String path) throws Exception {
        return (RequestProcessor)this.httpMappingTree.makeHandler((TDAConfiguration)this, path);
    }

    public void populateParameters(RequestProcessor instance, String path) {
        this.httpMappingTree.populate((RequestPathParameters)instance, path);
    }

    public WSProcessor makeWSHandler() throws Exception {
        return (WSProcessor)this.webSocketMappingTree.makeUniqueHandler((TDAConfiguration)this);
    }

    public void lambdaId(String awsRequestId) {
        if (this.mgrs != null) {
            for (AWSTxManager mgr : this.mgrs) {
                mgr.lambdaId(awsRequestId);
            }
        }
    }
}

