/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.grizzly.GrizzlyCookieSetter;
import org.ziniki.servlet.tda.CookieSetter;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;
import org.zinutils.exceptions.NotImplementedException;

public class AWSLambdaProxyResponse
implements Responder {
    private static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private int status = 200;
    private StringWriter sw = new StringWriter();
    private Throwable showErr;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>();
    private final Map<String, GrizzlyCookieSetter> cookies = new TreeMap<String, GrizzlyCookieSetter>();
    private int waitFor;
    private TimeUnit waitForUnit;
    private CompletableFuture<Void> completeMe;

    public int getStatusCode() {
        if (this.showErr != null) {
            return 500;
        }
        return this.status;
    }

    public Map<String, List<String>> getMultiValueHeaders() {
        TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>(this.headers);
        if (!this.cookies.isEmpty()) {
            ArrayList<String> cookieHeaders = new ArrayList<String>();
            for (GrizzlyCookieSetter gcs : this.cookies.values()) {
                cookieHeaders.add(gcs.toString());
            }
            ret.put("Set-Cookie", cookieHeaders);
        }
        return ret;
    }

    public String getBody() {
        if (this.showErr != null) {
            this.sw = new StringWriter();
            PrintWriter pw = new PrintWriter(this.sw);
            this.showErr.printStackTrace(pw);
            pw.flush();
        }
        return this.sw.toString();
    }

    public static AWSLambdaProxyResponse internalError(Throwable t) {
        AWSLambdaProxyResponse err = new AWSLambdaProxyResponse();
        err.handleError(t);
        return err;
    }

    public void setTimeout(int time, TimeUnit unit) {
        this.setTimeout(null, time, unit);
    }

    public void setTimeout(String message, int time, TimeUnit unit) {
        this.waitFor = time;
        this.waitForUnit = unit;
        this.completeMe = new CompletableFuture();
    }

    public void setStatus(int stat) {
        this.status = stat;
    }

    public void setHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new ArrayList());
        }
        this.headers.get(name).add(value);
    }

    public CookieSetter setCookie(String name, String value) {
        Cookie c = new Cookie(name, value);
        logger.info("Setting cookie " + c.asServerCookieString());
        GrizzlyCookieSetter grizzlyCookieSetter = new GrizzlyCookieSetter(c);
        this.cookies.put(name, grizzlyCookieSetter);
        return grizzlyCookieSetter;
    }

    public void clearCookie(String named) {
        Cookie c = new Cookie(named, "");
        c.setMaxAge(0);
        c.setPath("/");
        logger.info("Setting cookie " + c.asServerCookieString());
        GrizzlyCookieSetter grizzlyCookieSetter = new GrizzlyCookieSetter(c);
        this.cookies.put(named, grizzlyCookieSetter);
    }

    public void setContentType(String contentType) {
        this.headers.put("Content-Type", Arrays.asList(contentType));
    }

    public void setContentLength(long length) {
        throw new NotImplementedException();
    }

    public void redirectTo(String location) throws IOException {
        this.status = 302;
        this.headers.put("Location", Arrays.asList(location));
        this.setContentType("text/html");
        this.sw.write("<html><head><title>Document Moved</title></head><body>The document has moved to <a href='" + Response.filter((String)location) + "'></body></html>");
        this.done();
    }

    public boolean canWrite() {
        return true;
    }

    public boolean write(String string, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        this.sw.append(string);
        return true;
    }

    public boolean write(char[] cbuf, int offset, int cnt, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        this.sw.write(cbuf, offset, cnt);
        return true;
    }

    public boolean write(byte[] buf, int offset, int cnt, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        throw new NotImplementedException();
    }

    public void done() {
        if (this.completeMe != null) {
            logger.info("completing " + this.completeMe + " where waitFor = " + this.waitFor);
            this.completeMe.complete(null);
        }
    }

    public void handleError(Throwable err) {
        this.showErr = err;
    }

    public void waitForCompletion() throws Exception {
        logger.info("completeMe = " + this.completeMe + " and waitFor = " + this.waitFor);
        if (this.completeMe != null) {
            this.completeMe.get(this.waitFor, this.waitForUnit);
        }
    }
}

