/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.main.aws.AWSLambdaProxyRequest;
import org.ziniki.server.main.aws.AWSLambdaProxyResponse;
import org.ziniki.server.main.aws.AWSTDAServer;

public class AWSHandler
implements RequestHandler<AWSLambdaProxyRequest, AWSLambdaProxyResponse> {
    private static AWSTDAServer server = new AWSTDAServer(null);
    private static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");

    public AWSLambdaProxyResponse handleRequest(AWSLambdaProxyRequest request, Context cx) {
        try {
            if (server.initializationException() != null) {
                logger.error("Error initializing server", server.initializationException());
                throw server.initializationException();
            }
            server.lambdaId(cx.getAwsRequestId());
            AWSLambdaProxyResponse ret = new AWSLambdaProxyResponse();
            request.processTo(server, ret);
            logger.info("waiting for completion");
            ret.waitForCompletion();
            int rlen = 0;
            if (ret.getBody() != null) {
                rlen = ret.getBody().length();
            }
            logger.info("Response: status = " + ret.getStatusCode() + " " + rlen);
            if (logger.isDebugEnabled()) {
                logger.debug("Response text is " + ret.getBody());
            }
            return ret;
        }
        catch (Throwable t) {
            logger.error("Error processing request", t);
            return AWSLambdaProxyResponse.internalError(t);
        }
    }
}

