/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLaunchTemplatesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLaunchTemplatesResponse> {
    private static final SdkField<List<LaunchTemplate>> LAUNCH_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeLaunchTemplatesResponse.getter(DescribeLaunchTemplatesResponse::launchTemplates)).setter(DescribeLaunchTemplatesResponse.setter(Builder::launchTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplates").unmarshallLocationName("launchTemplates").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLaunchTemplatesResponse.getter(DescribeLaunchTemplatesResponse::nextToken)).setter(DescribeLaunchTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<LaunchTemplate> launchTemplates;
    private final String nextToken;

    private DescribeLaunchTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplates = builder.launchTemplates;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLaunchTemplates() {
        return this.launchTemplates != null && !(this.launchTemplates instanceof SdkAutoConstructList);
    }

    public List<LaunchTemplate> launchTemplates() {
        return this.launchTemplates;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplatesResponse)) {
            return false;
        }
        DescribeLaunchTemplatesResponse other = (DescribeLaunchTemplatesResponse)((Object)obj);
        return Objects.equals(this.launchTemplates(), other.launchTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLaunchTemplatesResponse").add("LaunchTemplates", this.launchTemplates()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplates": {
                return Optional.ofNullable(clazz.cast(this.launchTemplates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeLaunchTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LaunchTemplate> launchTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplatesResponse model) {
            super(model);
            this.launchTemplates(model.launchTemplates);
            this.nextToken(model.nextToken);
        }

        public final Collection<LaunchTemplate.Builder> getLaunchTemplates() {
            return this.launchTemplates != null ? (Collection)this.launchTemplates.stream().map(LaunchTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplates(Collection<LaunchTemplate> launchTemplates) {
            this.launchTemplates = LaunchTemplateSetCopier.copy(launchTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(LaunchTemplate ... launchTemplates) {
            this.launchTemplates(Arrays.asList(launchTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplates(Consumer<LaunchTemplate.Builder> ... launchTemplates) {
            this.launchTemplates(Stream.of(launchTemplates).map(c -> (LaunchTemplate)((LaunchTemplate.Builder)LaunchTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplates(Collection<LaunchTemplate.BuilderImpl> launchTemplates) {
            this.launchTemplates = LaunchTemplateSetCopier.copyFromBuilder(launchTemplates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchTemplatesResponse build() {
            return new DescribeLaunchTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLaunchTemplatesResponse> {
        public Builder launchTemplates(Collection<LaunchTemplate> var1);

        public Builder launchTemplates(LaunchTemplate ... var1);

        public Builder launchTemplates(Consumer<LaunchTemplate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

