/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelSpotInstanceRequestsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
    private static final SdkField<List<String>> SPOT_INSTANCE_REQUEST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CancelSpotInstanceRequestsRequest.getter(CancelSpotInstanceRequestsRequest::spotInstanceRequestIds)).setter(CancelSpotInstanceRequestsRequest.setter(Builder::spotInstanceRequestIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("SpotInstanceRequestId").build(), ListTrait.builder().memberLocationName("SpotInstanceRequestId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("SpotInstanceRequestId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_INSTANCE_REQUEST_IDS_FIELD));
    private final List<String> spotInstanceRequestIds;

    private CancelSpotInstanceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
    }

    public boolean hasSpotInstanceRequestIds() {
        return this.spotInstanceRequestIds != null && !(this.spotInstanceRequestIds instanceof SdkAutoConstructList);
    }

    public List<String> spotInstanceRequestIds() {
        return this.spotInstanceRequestIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest)((Object)obj);
        return Objects.equals(this.spotInstanceRequestIds(), other.spotInstanceRequestIds());
    }

    public String toString() {
        return ToString.builder((String)"CancelSpotInstanceRequestsRequest").add("SpotInstanceRequestIds", this.spotInstanceRequestIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotInstanceRequestIds": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotInstanceRequestsRequest, T> g) {
        return obj -> g.apply((CancelSpotInstanceRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> spotInstanceRequestIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsRequest model) {
            super(model);
            this.spotInstanceRequestIds(model.spotInstanceRequestIds);
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            return this.spotInstanceRequestIds;
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String ... spotInstanceRequestIds) {
            this.spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelSpotInstanceRequestsRequest build() {
            return new CancelSpotInstanceRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
        public Builder spotInstanceRequestIds(Collection<String> var1);

        public Builder spotInstanceRequestIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

