/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSubnetCidrBlockRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateSubnetCidrBlockRequest.getter(AssociateSubnetCidrBlockRequest::ipv6CidrBlock)).setter(AssociateSubnetCidrBlockRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("ipv6CidrBlock").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateSubnetCidrBlockRequest.getter(AssociateSubnetCidrBlockRequest::subnetId)).setter(AssociateSubnetCidrBlockRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_BLOCK_FIELD, SUBNET_ID_FIELD));
    private final String ipv6CidrBlock;
    private final String subnetId;

    private AssociateSubnetCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.subnetId = builder.subnetId;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String subnetId() {
        return this.subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSubnetCidrBlockRequest)) {
            return false;
        }
        AssociateSubnetCidrBlockRequest other = (AssociateSubnetCidrBlockRequest)((Object)obj);
        return Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.subnetId(), other.subnetId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateSubnetCidrBlockRequest").add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("SubnetId", (Object)this.subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSubnetCidrBlockRequest, T> g) {
        return obj -> g.apply((AssociateSubnetCidrBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String ipv6CidrBlock;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSubnetCidrBlockRequest model) {
            super(model);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.subnetId(model.subnetId);
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSubnetCidrBlockRequest build() {
            return new AssociateSubnetCidrBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSubnetCidrBlockRequest> {
        public Builder ipv6CidrBlock(String var1);

        public Builder subnetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

