/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziwsh.grizzly;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.tdastore.TxManager;
import org.ziniki.ziwsh.grizzly.GrizzlyConnectionStore;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshListenerDelegate;

public class ZiwshGrizzlyListener
implements WSReceiver,
ProvideHostInfo,
RequestPathParameters {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiwshGrizzlyListener");
    private GrizzlyConnectionStore connStore;
    private ZiwshListenerDelegate delegate;
    protected String host;
    protected String token;
    protected String secret;
    private TxManager txmanager;

    public ZiwshGrizzlyListener(@Param(value="txmanager") TxManager txmgr, @Param(value="connStore") GrizzlyConnectionStore connStore, @Param(value="delegate") ZiwshListenerDelegate delegate) {
        this.txmanager = txmgr;
        this.connStore = connStore;
        this.delegate = delegate;
        logger.info("Created a new ZiWSH Grizzly Listener");
    }

    protected void connect(TxManager txmgr, GrizzlyConnectionStore store, ZiwshListenerDelegate delegate) {
        this.txmanager = txmgr;
        this.connStore = store;
        this.delegate = delegate;
    }

    public void provideHost(String name, int port) {
        this.host = name;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("token".equals(name)) {
            this.token = value;
        } else if ("secret".equals(name)) {
            this.secret = value;
        }
    }

    public void open(WSResponder responder) {
        GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.newUnit();
        logger.info("Received open request with " + responder + " and " + this.token + "/" + this.secret);
        this.delegate.open((WebSocketFinder)this.connStore, (EvalContext)uow, this.host, this.token, this.secret, responder);
        uow.enact();
        uow.waitForResult();
    }

    public void onText(WSResponder responder, String text) {
        GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.newUnit();
        logger.info("Received text " + text);
        this.delegate.handle((WebSocketFinder)this.connStore, (EvalContext)uow, this.host, this.token, responder, text);
        uow.enact();
        uow.waitForResult();
    }

    public void error() {
    }

    public void close(Object responder) {
    }

    public void hasSegment(String segment) {
    }

    public void integerValue(String name, int value, ParameterSource source) {
    }

    public void doubleValue(String name, double value, ParameterSource source) {
    }
}

