/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.ziniki.ziwsh;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.core.ActualZinikiUOW;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.intf.ZinikiUOW;
import org.ziniki.openid.fl.ZinikiSecurityToken;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EntryId;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshListenerDelegate;

public class BrokerDelegate
implements ZiwshListenerDelegate,
RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"BrokerDelegate");
    private ZiIdFactory factory;

    public BrokerDelegate(@Param(value="idfactory") ZiIdFactory factory) {
        this.factory = factory;
        logger.info("Created a new BrokerDelegate");
    }

    public void open(WebSocketFinder finder, EvalContext cx, String host, String token, String secret, WSResponder replyTo) {
        logger.info("opening websocket for " + token);
        replyTo.setDessication(token);
        try {
            GLUnitOfWork uow = (GLUnitOfWork)cx;
            uow.trait(UOWHost.class, (Object)new UOWHost(host.replace("ziniki.", "")));
            ZiId id = this.factory.simple("security", ((UOWHost)uow.trait(UOWHost.class)).host, "token", token);
            Relation r = uow.relation((RelationHandler)this);
            r.load((Object)finder);
            r.load((Object)replyTo);
            r.load("token", (Object)token);
            r.load("secret", (Object)secret);
            r.logic("rememberToken");
            r.get("tok", id.toString());
            uow.makeReady(r);
        }
        catch (Exception ex) {
            logger.error("Error", (Throwable)ex);
        }
    }

    public void rememberToken(WebSocketFinder finder, UnitOfWork uow, @Slot(value="token") String token, @Slot(value="tok") ZinikiSecurityToken tok, @Slot(value="secret") String secret, WSResponder responder) {
        if (tok == null) {
            logger.error("there was no token " + token);
            responder.close("invalid token");
            return;
        }
        if (!secret.equals(tok.getSecret())) {
            logger.error("secret did not match for token " + token);
            responder.close("invalid secret");
            return;
        }
        logger.info("remembering responder " + responder + " for token " + tok);
        finder.remember((EvalContext)uow, (EntryId)tok, secret, responder);
    }

    public void handle(WebSocketFinder finder, EvalContext cx, String host, String token, WSResponder responder, String text) {
        try {
            GLUnitOfWork uow = (GLUnitOfWork)cx;
            uow.trait(UOWHost.class, (Object)new UOWHost(host.replace("ziniki.", "")));
            ZiId id = this.factory.simple("security", ((UOWHost)uow.trait(UOWHost.class)).host, "token", token);
            Relation r = uow.relation((RelationHandler)this);
            r.load((Object)finder);
            r.load((Object)responder);
            r.load("id", (Object)id.toString());
            r.load("message", (Object)text);
            r.logic("dispatchMessage");
            r.get("tok", id.toString());
            uow.makeReady(r);
        }
        catch (Exception ex) {
            logger.error("Error", (Throwable)ex);
        }
    }

    public void dispatchMessage(UnitOfWork uow, WebSocketFinder finder, @Slot(value="id") String id, @Slot(value="tok") ZinikiSecurityToken tok, WSResponder responder, @Slot(value="message") String msg) {
        if (tok == null) {
            throw new RuntimeException("no security token found for " + id);
        }
        logger.info("token " + tok.getToken() + " found with " + tok);
        WebSocketFinder.Entry e = finder.find((EntryId)tok);
        if (e == null) {
            throw new RuntimeException("There is no handler for token " + tok.getToken());
        }
        uow.trait(ZinikiUOW.class, (Object)new ActualZinikiUOW(tok));
        e.dispatch((EvalContext)uow, msg);
    }
}

