/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpFetcherFactory;
import org.ziniki.servlet.SSLPatch;
import org.ziniki.ziwsh.intf.Param;

public class ZinikiConsumerManager
extends ConsumerManager {
    private static final String disableCertOption = System.getenv("ZINIKI_DISABLE_OPENID_CERTS");
    private static final String disableCertProp = System.getProperty("ziniki.disable.openid.certs");
    private static final boolean disableCerts = "disable".equals(disableCertOption) || "disable".equals(disableCertProp);

    public ZinikiConsumerManager(@Param(value="assocStore") ConsumerAssociationStore assocStore, @Param(value="privateAssociationStore") ConsumerAssociationStore privateStore, @Param(value="nonceVerifier") NonceVerifier nonceVerifier) throws Exception {
        super(ZinikiConsumerManager.rvf(), ZinikiConsumerManager.d(), ZinikiConsumerManager.hff());
        this.setAssociations(assocStore);
        this.setPrivateAssociationStore(privateStore);
        this.setNonceVerifier(nonceVerifier);
    }

    private static RealmVerifierFactory rvf() throws Exception {
        if (disableCerts) {
            YadisResolver yr = new YadisResolver(ZinikiConsumerManager.hff());
            return new RealmVerifierFactory(yr);
        }
        return new RealmVerifierFactory(new YadisResolver(ZinikiConsumerManager.hff()));
    }

    private static Discovery d() throws Exception {
        if (disableCerts) {
            YadisResolver yr = new YadisResolver(ZinikiConsumerManager.hff());
            return new Discovery(new HtmlResolver(ZinikiConsumerManager.hff()), yr, Discovery.getXriResolver());
        }
        return new Discovery();
    }

    private static HttpFetcherFactory hff() throws Exception {
        if (disableCerts) {
            SSLContext sc = SSLPatch.disableSSLCertValidation();
            return new HttpFetcherFactory(sc, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        return new HttpFetcherFactory();
    }
}

