/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import org.openid4java.consumer.ConsumerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.common.UOWHost;
import org.ziniki.core.ZinikiCore;
import org.ziniki.core.concepts.Domain;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.server.tda.writers.BackwardsCompatibleBlockingWriter;
import org.ziniki.servlet.tda.CookieAware;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.support.ThreadAwareTxManager;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.IRandom;

public abstract class Security
implements RequestProcessor,
ProvideHostInfo,
RequestMethod,
RequestQueryAndPostParameters,
CookieAware,
RelationHandler {
    protected final IRandom random;
    protected final Logger logger = LoggerFactory.getLogger((String)"Security");
    protected final ConsumerManager consumer;
    protected final TemplateEngine te;
    protected final ZinikiCore core;
    protected final ThreadAwareTxManager txmanager;
    protected final SecurityStore securityStore;
    private String methodName;
    protected String userid;
    protected UnitOfWork uow;
    protected Relation r;
    private String wantRedir;
    protected String domain;
    private ZiIdFactory factory;

    public Security(IRandom random, ConsumerManager consumer, TxManager txmanager, ZinikiCore core, SecurityStore securityStore, TemplateEngine te, ZiIdFactory factory) {
        this.random = random;
        this.consumer = consumer;
        this.txmanager = (ThreadAwareTxManager)txmanager;
        this.core = core;
        this.securityStore = securityStore;
        this.te = te;
        this.factory = factory;
    }

    public void provideHost(String name, int port) {
        this.logger.info("Request has come in on " + name + " and " + port);
        this.domain = name.replace("ziniki.", "");
    }

    public void requestMethod(String methodName) {
        this.methodName = methodName;
    }

    protected boolean isGet() {
        return "GET".equals(this.methodName);
    }

    protected boolean isPost() {
        return "POST".equals(this.methodName);
    }

    public void stringValue(String name, String value, ParameterSource source) {
    }

    public String[] cookiesWanted() {
        return new String[]{"userid"};
    }

    public void cookie(String name, String value) {
        if (name.equals("userid")) {
            this.userid = value;
            this.logger.info("cookie 'userid' has value " + this.userid);
        }
    }

    protected void before(Responder resp) {
        try {
            this.uow = this.txmanager.newUnit();
            this.uow.trait(UOWHost.class, (Object)new UOWHost(this.domain));
            resp.setTimeout(this.uow.id() + " " + this.methodName + " " + this.getClass().getName(), 5, TimeUnit.SECONDS);
            this.r = this.uow.relation((RelationHandler)this);
            String did = this.factory.unique("ziniki", this.domain, "domain").toString();
            this.r.get("domain", did);
            this.r.load((Object)resp);
            this.r.logic("checkDomainExists");
            this.logger.info("Security Servlet handling " + this.methodName + " " + this.getClass().getName());
            this.logger.info("userid = " + this.userid);
            if (this.userid != null) {
                this.r.load("userid", (Object)this.userid);
                this.r.load("needed_new", (Object)false);
            } else {
                this.setNewUserId();
                this.r.load("needed_new", (Object)true);
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void checkDomainExists(UnitOfWork uow, @Slot(value="domain") Domain domain) {
        if (domain == null) {
            uow.fatalError((Throwable)new RuntimeException("There is no domain " + this.domain));
        }
    }

    public void setNewUserId() throws GLSException {
        this.securityStore.newSessionToken(this.uow, this.r);
        this.r.logic("applyUserIdCookie");
    }

    public void applyUserIdCookie(Responder resp, Relation r, @Slot(value="new_userid") String userid) {
        this.logger.info("Created new session with token " + userid);
        resp.setCookie("userid", userid).setPath("/");
        r.load("userid", (Object)userid);
        r.load("generated_userid", (Object)userid);
    }

    protected void after() throws GLSException {
        this.r.whenCommitted("sendResponse");
        this.r.whenRolledBack("clearResponse");
        this.uow.enact();
        this.uow.waitForResult();
        this.txmanager.currentThreadUOW(null);
    }

    protected void redirectTo(String url) {
        this.wantRedir = url;
    }

    public void sendResponse(Responder resp) throws IOException {
        if (this.wantRedir != null) {
            resp.redirectTo(this.wantRedir);
        } else {
            resp.done();
        }
    }

    public void clearResponse(Responder resp) throws IOException {
        resp.setStatus(400);
        resp.done();
    }

    protected void handleException(Responder resp, Exception ex) throws IOException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        this.logger.error("Failure in " + this.getClass(), (Throwable)ex);
        resp.setStatus(500);
        resp.setContentType("text/plain");
        PrintWriter w = new PrintWriter((Writer)new BackwardsCompatibleBlockingWriter(resp));
        ex.printStackTrace(w);
        w.flush();
        this.txmanager.currentThreadUOW(null);
    }

    public void send405(Responder resp) {
        resp.setStatus(405);
    }
}

