/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.ziniki.core.ZinikiCore;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.servlet.Security;
import org.ziniki.servlet.tda.NeedFullURLWithQuery;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GoingToBlock;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.IRandom;

public class OpenIdCallbackAction
extends Security
implements NeedFullURLWithQuery {
    private final Map<String, String[]> map = new HashMap<String, String[]>();
    private String fullUrl;
    private final String loginCompleteUrl;

    public OpenIdCallbackAction(@Param(value="zinikiUri") String zinikiUri, @Param(value="random") IRandom random, @Param(value="consumerManager") ConsumerManager consumer, @Param(value="txmanager") TxManager txmanager, @Param(value="storage") TDAStorage storage, @Param(value="core") ZinikiCore core, @Param(value="securityStore") SecurityStore securityStore, @Param(value="templateEngine") TemplateEngine te, @Param(value="idfactory") ZiIdFactory factory) {
        super(random, consumer, txmanager, core, securityStore, te, factory);
        this.loginCompleteUrl = zinikiUri + "/loginComplete";
    }

    public void fullURLWithQuery(String s) {
        this.fullUrl = s;
    }

    @Override
    public void stringValue(String name, String value, ParameterSource source) {
        this.map.put(name, new String[]{value});
    }

    public void process(Responder resp) throws IOException {
        super.before(resp);
        try {
            if (this.isGet()) {
                this.r.logic("handleOpenID2Callback");
            } else {
                this.r.logic("send405");
            }
            super.after();
        }
        catch (Exception ex) {
            super.handleException(resp, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoingToBlock
    public void handleOpenID2Callback(Responder resp) throws IOException, MessageException, DiscoveryException, AssociationException, NotReadyException {
        Identifier verified;
        VerificationResult verification;
        ParameterList responseparams = new ParameterList(this.map);
        this.logger.info("OpenID2Callback called with " + this.map);
        ConsumerManager consumerManager = this.consumer;
        synchronized (consumerManager) {
            this.logger.info("verifying that " + responseparams.getParameterValue("openid.return_to") + " matches " + this.fullUrl);
            verification = this.consumer.verify(this.fullUrl, responseparams, null);
            verified = verification.getVerifiedId();
            if (verified == null && this.fullUrl.startsWith("http:")) {
                String s = "https" + this.fullUrl.substring(4);
                this.logger.info("Auth failed with http; trying again with https");
                verification = this.consumer.verify(s, responseparams, null);
                verified = verification.getVerifiedId();
            }
        }
        if (verified == null) {
            resp.setStatus(403);
            resp.write("<html><body>Login failed because verification failed.  Really?</body></html>", null);
            return;
        }
        this.logger.info("verified user " + verified);
        String cred = ((AuthSuccess)verification.getAuthResponse()).getIdentity();
        this.logger.info("Decided credential was for " + cred);
        this.securityStore.bindSessionToCredential(this.uow, this.userid, cred);
        this.redirectTo(this.loginCompleteUrl);
    }
}

