/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.ziniki.core.ZinikiCore;
import org.ziniki.interfaces.CredState;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.fl.ZinikiSecurityToken;
import org.ziniki.server.tda.writers.ContinuationWriter;
import org.ziniki.servlet.Security;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.GoingToBlock;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.IRandom;

public class Login
extends Security {
    private final String returnToUrl;
    private final String loginCompleteUrl;
    private final ZiIdFactory factory;
    private String openid;

    public Login(@Param(value="zinikiUri") String zinikiUrl, @Param(value="random") IRandom random, @Param(value="consumerManager") ConsumerManager consumer, @Param(value="txmanager") TxManager txmanager, @Param(value="storage") TDAStorage storage, @Param(value="core") ZinikiCore core, @Param(value="securityStore") SecurityStore securityStore, @Param(value="templateEngine") TemplateEngine te, @Param(value="idfactory") ZiIdFactory factory) {
        super(random, consumer, txmanager, core, securityStore, te, factory);
        this.factory = factory;
        this.returnToUrl = zinikiUrl + "/openid_callback";
        this.loginCompleteUrl = zinikiUrl + "/loginComplete";
    }

    @Override
    public void stringValue(String name, String value, ParameterSource source) {
        if (name.equals("openid")) {
            this.openid = value;
        }
    }

    public void process(Responder resp) throws IOException {
        super.before(resp);
        try {
            if (!this.isGet() && !this.isPost()) {
                this.send405(resp);
            } else {
                if (this.userid == null) {
                    this.r.load("token", null);
                } else {
                    this.r.get("token", this.factory.simple("security", this.domain, "token", this.userid).toString());
                }
                this.r.logic("ensureWeAreNotLoggedIn");
            }
            super.after();
        }
        catch (Exception ex) {
            super.handleException(resp, ex);
        }
    }

    public void ensureWeAreNotLoggedIn(@Slot(value="token") ZinikiSecurityToken token, @Slot(value="needed_new") boolean createdNew) throws GLSException {
        if (token != null && token.state() != CredState.EMPTY) {
            this.redirectTo(this.loginCompleteUrl);
            return;
        }
        if (token == null && !createdNew) {
            this.setNewUserId();
        } else if (!createdNew) {
            this.r.load("generated_userid", (Object)"false");
        }
        if (this.isGet()) {
            this.r.logic("generateLoginOptions");
        } else if (this.isPost()) {
            this.r.logic("initiateLogin");
        }
    }

    public void generateLoginOptions(Responder resp, @Slot(value="generated_userid") String newuserid) throws IOException, TemplateException, GLSException {
        this.te.sendResource(resp, "loginOptions.fm", new HashMap());
    }

    @GoingToBlock
    public void initiateLogin(Responder resp, @Slot(value="generated_userid") String newuserid) throws IOException, NotReadyException, DiscoveryException, MessageException, ConsumerException, GLSException {
        List discoveries;
        if (this.openid == null) {
            resp.setStatus(401);
            resp.setContentType("text/plain");
            resp.write("no openid provided", null);
            return;
        }
        this.logger.info("Attempting to associate with " + this.openid);
        this.consumer.setConnectTimeout(25000);
        this.consumer.setSocketTimeout(25000);
        int tries = 0;
        while (true) {
            try {
                discoveries = this.consumer.discover(this.openid);
            }
            catch (YadisException ex) {
                this.logger.error(tries + "/3: Caught YadisException: " + ex + " trying to associate with " + this.openid);
                if (ex.getCause() instanceof SocketTimeoutException && ++tries <= 3) continue;
                throw ex;
            }
            break;
        }
        DiscoveryInformation discovered = this.consumer.associate(discoveries);
        AuthRequest authReq = this.consumer.authenticate(discovered, this.returnToUrl);
        if (!discovered.isVersion2()) {
            this.redirectTo(authReq.getDestinationUrl(true));
        } else {
            ContinuationWriter pw = new ContinuationWriter(resp);
            pw.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
            pw.write("<head>\n");
            pw.write("    <title>OpenID HTML FORM Redirection</title>\n");
            pw.write("</head>\n");
            pw.write("<body onload=\"document.forms['openid-form-redirection'].submit();\">\n");
            pw.write("    <form name=\"openid-form-redirection\" action=\"" + authReq.getOPEndpoint() + "\" method=\"post\" accept-charset=\"utf-8\">\n");
            Map pm = authReq.getParameterMap();
            for (Object key : pm.keySet()) {
                Object value = pm.get(key);
                pw.write("        <input type=\"hidden\" name=\"" + key + "\" value=\"" + value + "\"/>\n");
            }
            pw.write("<button type=\"submit\">Continue...</button>\n");
            pw.write("    </form>\n");
            pw.write("</body>\n");
            pw.write("</html>\n");
        }
    }
}

