/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.servlet;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.server.tda.writers.BackwardsCompatibleBlockingWriter;
import org.ziniki.servlet.S3TemplateLoader;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.ziwsh.intf.Param;

public class FreemarkerTemplatingEngine
implements TemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger((String)"FreeMarker");
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);

    public FreemarkerTemplatingEngine(@Param(value="root") File rootdir, @Param(value="templateDir") String path) throws IOException {
        logger.info("Loading templates from " + path);
        if (path.startsWith("s3:")) {
            this.cfg.setTemplateLoader((TemplateLoader)new S3TemplateLoader(path));
        } else {
            File from = new File(path);
            if (!from.exists() && rootdir != null) {
                from = new File(rootdir, path);
            }
            this.cfg.setDirectoryForTemplateLoading(from);
        }
        this.cfg.setDefaultEncoding("UTF-8");
    }

    public void sendResource(Responder resp, String templateName, Map<String, Object> model) throws IOException, TemplateException {
        resp.setStatus(200);
        resp.setContentType("text/html");
        Template template = this.cfg.getTemplate(templateName);
        template.process(model, (Writer)new BackwardsCompatibleBlockingWriter(resp));
    }
}

