/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary;

public class ListStackSetOperationsIterable
implements SdkIterable<ListStackSetOperationsResponse> {
    private final CloudFormationClient client;
    private final ListStackSetOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackSetOperationsIterable(CloudFormationClient client, ListStackSetOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStackSetOperationsResponseFetcher();
    }

    public Iterator<ListStackSetOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackSetOperationSummary> summaries() {
        Function<ListStackSetOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackSetOperationsResponseFetcher
    implements SyncPageFetcher<ListStackSetOperationsResponse> {
        private ListStackSetOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackSetOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackSetOperationsResponse nextPage(ListStackSetOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListStackSetOperationsIterable.this.client.listStackSetOperations(ListStackSetOperationsIterable.this.firstRequest);
            }
            return ListStackSetOperationsIterable.this.client.listStackSetOperations((ListStackSetOperationsRequest)((Object)ListStackSetOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

