/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;

public class DescribeStackResourceDriftsPublisher
implements SdkPublisher<DescribeStackResourceDriftsResponse> {
    private final CloudFormationAsyncClient client;
    private final DescribeStackResourceDriftsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStackResourceDriftsPublisher(CloudFormationAsyncClient client, DescribeStackResourceDriftsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStackResourceDriftsPublisher(CloudFormationAsyncClient client, DescribeStackResourceDriftsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStackResourceDriftsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStackResourceDriftsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeStackResourceDriftsResponseFetcher
    implements AsyncPageFetcher<DescribeStackResourceDriftsResponse> {
        private DescribeStackResourceDriftsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackResourceDriftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStackResourceDriftsResponse> nextPage(DescribeStackResourceDriftsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackResourceDriftsPublisher.this.client.describeStackResourceDrifts(DescribeStackResourceDriftsPublisher.this.firstRequest);
            }
            return DescribeStackResourceDriftsPublisher.this.client.describeStackResourceDrifts((DescribeStackResourceDriftsRequest)((Object)DescribeStackResourceDriftsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

