/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.parsing.impl;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.FieldsHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.ConsumeStructFields;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.StructFieldConsumer;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAStructFieldParser;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.parser.TopLevelNamer;
import org.flasck.flas.parser.VarNamer;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.compiler.parsing.impl.SecondaryDefn;
import org.ziniki.compiler.parsing.impl.SecondaryFieldParser;

public class ZinikiKeywordParsing
implements TDAParsing {
    public final Logger logger = LoggerFactory.getLogger((String)"ZinikiParsing");
    private final ErrorReporter errors;
    private final TopLevelNamer namer;
    private final TopLevelDefinitionConsumer consumer;

    public ZinikiKeywordParsing(ErrorReporter errors, TopLevelNamer namer, TopLevelDefinitionConsumer consumer) {
        this.errors = errors;
        this.namer = namer;
        this.consumer = consumer;
    }

    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from((Tokenizable)toks);
        if (kw == null) {
            return null;
        }
        switch (kw.text) {
            case "arena": {
                TypeNameToken tn = TypeNameToken.unqualified((Tokenizable)toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid or missing type name");
                    return new IgnoreNestedParser();
                }
                SolidName sn = this.namer.solidName(tn.text);
                SimpleVarNamer svn = new SimpleVarNamer((NameOfThing)sn);
                ArrayList polys = new ArrayList();
                StructDefn sd = new StructDefn(kw.location, tn.location, FieldsDefn.FieldsType.ARENA, sn, true, polys);
                this.consumer.newStruct(this.errors, sd);
                return new TDAStructFieldParser(this.errors, (StructFieldConsumer)new ConsumeStructFields(this.errors, this.consumer, (VarNamer)svn, (FieldsDefn)sd), FieldsDefn.FieldsType.ARENA, true);
            }
            case "persona": {
                TypeNameToken tn = TypeNameToken.unqualified((Tokenizable)toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid or missing type name");
                    return new IgnoreNestedParser();
                }
                SolidName sn = this.namer.solidName(tn.text);
                SimpleVarNamer svn = new SimpleVarNamer((NameOfThing)sn);
                ArrayList polys = new ArrayList();
                StructDefn sd = new StructDefn(kw.location, tn.location, FieldsDefn.FieldsType.PERSONA, sn, true, polys);
                sd.addField(new StructField(tn.location, null, (FieldsHolder)sd, true, true, LoadBuiltins.stringTR, "profilename", null));
                this.consumer.newStruct(this.errors, sd);
                return new TDAStructFieldParser(this.errors, (StructFieldConsumer)new ConsumeStructFields(this.errors, this.consumer, (VarNamer)svn, (FieldsDefn)sd), FieldsDefn.FieldsType.ARENA, true);
            }
            case "secondary": {
                KeywordToken sectype = KeywordToken.from((Tokenizable)toks);
                if (sectype == null) {
                    this.errors.message(toks, "secondary must be key or index");
                    return new IgnoreNestedParser();
                }
                String secty = sectype.text;
                if (!"key".equals(secty) && !"index".equals(secty)) {
                    this.errors.message(sectype.location, "secondary must be key or index");
                    return new IgnoreNestedParser();
                }
                TypeNameToken secName = TypeNameToken.unqualified((Tokenizable)toks);
                if (secName == null) {
                    this.errors.message(toks, "invalid or missing secondary name");
                    return new IgnoreNestedParser();
                }
                TypeNameToken ofType = TypeNameToken.qualified((Tokenizable)toks);
                boolean byType = false;
                if (ofType == null) {
                    InputPosition pos = toks.realinfo();
                    KeywordToken by = KeywordToken.from((Tokenizable)toks);
                    KeywordToken type = null;
                    if (by != null) {
                        type = KeywordToken.from((Tokenizable)toks);
                    }
                    if (by.text.equals("by") && type != null && type.text.equals("type")) {
                        byType = true;
                    } else {
                        this.errors.message(pos, "invalid or missing secondary coverage type");
                        return new IgnoreNestedParser();
                    }
                }
                if (toks.hasMoreContent()) {
                    this.errors.message(toks, "syntax error");
                    return new IgnoreNestedParser();
                }
                SolidName fullName = this.namer.solidName(secName.text);
                SecondaryDefn sd = new SecondaryDefn(secName.location, secty, fullName, byType ? null : new TypeReference(ofType.location, ofType.text, new ArrayList()));
                this.consumer.addEntry(this.errors, (NameOfThing)fullName, (RepositoryEntry)sd);
                if (byType) {
                    return new NoNestingParser(this.errors);
                }
                return new SecondaryFieldParser(this.errors, sd);
            }
        }
        return null;
    }

    public void scopeComplete(InputPosition location) {
    }
}

