/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.parsing.impl;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.ziniki.compiler.parsing.impl.SecondaryDefn;

public class SecondaryFieldParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final SecondaryDefn sd;

    public SecondaryFieldParser(ErrorReporter errors, SecondaryDefn sd) {
        this.errors = errors;
        this.sd = sd;
    }

    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken var = VarNameToken.from((Tokenizable)toks);
        if (var == null) {
            this.errors.message(toks, "invalid or missing field name");
            return new IgnoreNestedParser();
        }
        if (toks.hasMoreContent()) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser();
        }
        this.sd.addField(new UnresolvedVar(var.location, var.text));
        return new NoNestingParser(this.errors);
    }

    public void scopeComplete(InputPosition location) {
    }
}

