/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.tdastore.support;

import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.ziwsh.intf.Param;

public class UOWExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"UOWExec");
    private final Executor underlying;
    private final Executor blocking;

    public UOWExecutor(@Param(value="executor") Executor underlying, @Param(value="blocking") Executor blocking) {
        this.underlying = underlying;
        this.blocking = blocking;
    }

    public Executor getMain() {
        return this.underlying;
    }

    public void execute(ThreadAwareUOW uow, boolean willBlock, Runnable runnable) {
        Runnable command = () -> {
            try {
                uow.getManager().currentThreadUOW(uow);
                runnable.run();
            }
            catch (Throwable t) {
                logger.error("Error processing command in UOW", t);
            }
            finally {
                uow.getManager().currentThreadUOW(null);
            }
        };
        if (willBlock) {
            this.blocking.execute(command);
        } else {
            this.underlying.execute(command);
        }
    }
}

