/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.tdastore.support;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.RelationAction;
import org.ziniki.tdastore.gls.SetterRunner;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.support.InvokeSet;
import org.ziniki.tdastore.support.ThreadAwareTxManager;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.streamedlogger.api.LabelBinder;
import org.zinutils.utils.StringUtil;

public abstract class TxManagerThreading
implements ThreadAwareTxManager {
    protected final Logger logger = LoggerFactory.getLogger((String)"TxManagerThreading");
    private final ThreadLocal<UnitOfWork> thrlocal = new ThreadLocal();
    private final String pfx;
    private final AtomicInteger nextId;
    private LabelBinder labeller;

    public TxManagerThreading(String pfx, int base) {
        this.pfx = pfx;
        this.nextId = new AtomicInteger(base);
    }

    public UnitOfWork currentUOW() {
        UnitOfWork ret = this.thrlocal.get();
        if (ret == null) {
            throw new RuntimeException("This thread does not have a current unit of work");
        }
        return ret;
    }

    public String currentUOWId() {
        UnitOfWork ret = this.thrlocal.get();
        if (ret == null) {
            return null;
        }
        return ret.id();
    }

    @Override
    public void currentThreadUOW(UnitOfWork uow) {
        this.thrlocal.set(uow);
        if (this.labeller != null) {
            if (uow == null) {
                this.labeller.bindLabelToThread(null);
            } else {
                this.labeller.bindLabelToThread(uow.id());
            }
        }
    }

    @Override
    public void labeller(LabelBinder labeller) {
        this.labeller = labeller;
    }

    @Override
    public SetterRunner runSetActions(final TDAStorage storage, final UOWExecutor exec, final UnitOfWork uow, final List<InvokeSet> allSets) {
        if (allSets.isEmpty()) {
            this.logger.info("there are no set operations");
            uow.txdone();
            return null;
        }
        this.resolveLocalUpdates(uow, allSets);
        InvokeSet firstAction = allSets.get(0);
        this.logger.info("firing first set action " + firstAction);
        firstAction.invoke(storage, exec, uow);
        return new SetterRunner(){
            AtomicBoolean doneFirst = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForSets(RelationAction action) {
                List list = allSets;
                synchronized (list) {
                    for (InvokeSet cis : allSets) {
                        if (!cis.is(action)) continue;
                        allSets.remove(cis);
                        if (allSets.isEmpty()) {
                            uow.txdone();
                        } else if (!this.doneFirst.getAndSet(true)) {
                            TxManagerThreading.this.logger.info("have completed " + action + "; firing " + allSets.size() + " others");
                            for (InvokeSet csra : allSets) {
                                csra.invoke(storage, exec, uow);
                            }
                        }
                        return;
                    }
                }
                throw new RuntimeException("Do not have " + action);
            }
        };
    }

    private void resolveLocalUpdates(UnitOfWork uow, List<InvokeSet> allSets) {
        InvokeSet is;
        Iterator<InvokeSet> it = allSets.iterator();
        while (it.hasNext()) {
            is = it.next();
            if (!is.updateLocalCreate(uow)) continue;
            it.remove();
        }
        it = allSets.iterator();
        while (it.hasNext()) {
            is = it.next();
            if (!is.forgetMe()) continue;
            it.remove();
        }
    }

    protected String nextId() {
        int k = this.nextId.accumulateAndGet(23, (a, b) -> (a + b) % 65536);
        return this.pfx + "-" + StringUtil.hex((long)k, (int)4);
    }
}

