/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid.auth;

import java.util.Base64;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.flasck.jvm.FLEvalContext;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.ServerAssociationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.auth.fl.AssociationRecord;
import org.ziniki.openid.auth.fl.JVMAssociationRecord;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.IRandom;
import org.zinutils.utils.StringUtil;

public class CouchbaseServerAssociationStore
implements ServerAssociationStore,
RelationHandler {
    private final Logger logger = LoggerFactory.getLogger((String)"CouchbaseServerAssociationStore");
    private final TxManager txmanager;
    private final TDAStorage storage;
    private final ZiIdFactory factory;
    private final IRandom random;
    private final String which;

    public CouchbaseServerAssociationStore(TxManager txmanager, TDAStorage storage, ZiIdFactory factory, IRandom random, boolean isPrivate) {
        this.txmanager = txmanager;
        this.storage = storage;
        this.factory = factory;
        this.random = random;
        this.which = isPrivate ? "private" : "shared";
    }

    public Association generate(String type, int expiryIn) throws AssociationException {
        try {
            UnitOfWork zu = this.txmanager.newUnit();
            Relation r = zu.relation((RelationHandler)this);
            r.load("type", (Object)type);
            r.load("expiry", (Object)expiryIn);
            r.logic("tryToCreateAssoc");
            zu.block();
            Association association = (Association)zu.read(r, "assoc");
            this.logger.info(this.which + " generated association " + association);
            return association;
        }
        catch (GLSException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void tryToCreateAssoc(UnitOfWork uow, Relation r, @Slot(value="type") String type, @Slot(value="expiry") int expiryIn) throws AssociationException {
        GLUnitOfWork zu = (GLUnitOfWork)uow;
        String handle = "assoc" + StringUtil.hex((long)this.random.nextInt(Integer.MAX_VALUE), (int)8);
        Association association = Association.generate((String)type, (String)handle, (int)expiryIn);
        r.load("assoc", (Object)association);
        ZiId id = this.factory.simple("openid", ((UOWHost)zu.trait(UOWHost.class)).host, "assoc", handle);
        r.createOrRetry(id.toString(), (Object)this.fromAssociation((FLEvalContext)zu, association), this.storage.expireAt(association.getExpiry()));
    }

    public Association load(String handle) {
        UnitOfWork zu = this.txmanager.newUnit();
        Relation r = zu.relation((RelationHandler)this);
        ZiId id = this.factory.simple("openid", ((UOWHost)zu.trait(UOWHost.class)).host, "assoc", handle);
        CompletableFuture ret = new CompletableFuture();
        r.get("assoc", id.toString(), x -> {
            this.logger.info("get returned value for assoc; making association");
            ret.complete(this.makeAssociation((AssociationRecord)x));
            this.logger.info("completed with association");
            return x;
        });
        zu.block();
        try {
            this.logger.info("After block, ret is " + ret.isDone() + " with exception: " + ret.isCompletedExceptionally());
            return (Association)ret.get();
        }
        catch (Exception ex) {
            this.logger.error("failed to get result from ret", (Throwable)ex);
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void remove(String handle) {
        UnitOfWork zu = this.txmanager.newUnit();
        Relation r = zu.relation((RelationHandler)this);
        ZiId id = this.factory.simple("openid", ((UOWHost)zu.trait(UOWHost.class)).host, "assoc", handle);
        r.delete(id.toString());
        zu.block();
    }

    private AssociationRecord fromAssociation(FLEvalContext cx, Association assoc) {
        JVMAssociationRecord ret = new JVMAssociationRecord(cx);
        ret.set("handle", assoc.getHandle());
        ret.set("type", assoc.getType());
        ret.set("mackey", new String(Base64.getEncoder().encodeToString(assoc.getMacKey().getEncoded())));
        ret.set("expiry", assoc.getExpiry());
        return ret;
    }

    protected Association makeAssociation(AssociationRecord assoc) {
        if (assoc == null) {
            this.logger.error("no association retrieved from database");
            return null;
        }
        String handle = assoc.getHandle();
        String type = assoc.getType();
        String macKey = assoc.getMacKey();
        Date expDate = assoc.getExpiry();
        if ("HMAC-SHA1".equals(type)) {
            return Association.createHmacSha1((String)handle, (byte[])Base64.getDecoder().decode(macKey), (Date)expDate);
        }
        if ("HMAC-SHA256".equals(type)) {
            return Association.createHmacSha256((String)handle, (byte[])Base64.getDecoder().decode(macKey), (Date)expDate);
        }
        this.logger.error("Invalid association type retrieved from database: " + type);
        return null;
    }
}

