/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.interfaces.TemplateEngine;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.auth.fl.JVMApprovalRecord;
import org.ziniki.openid.auth.fl.JVMLoginRecord;
import org.ziniki.openid.auth.fl.LoginRecord;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.Crypto;

public class Challenger
implements RequestProcessor,
RequestMethod,
ProvideHostInfo,
RequestQueryAndPostParameters,
RelationHandler {
    private final Logger logger = LoggerFactory.getLogger((String)"Challenger");
    private final TxManager txmanager;
    private final ZiIdFactory factory;
    private final String idurl;
    private final String authUrl;
    private final String challengeUrl;
    private String method;
    private String challengeid;
    private String username;
    private String password;
    private Mode mode;
    private final TemplateEngine templateEngine;
    private String host;

    public Challenger(@Param(value="txmanager") TxManager txmanager, @Param(value="idfactory") ZiIdFactory factory, @Param(value="idurl") String idUrl, @Param(value="authurl") String authUrl, @Param(value="challengeUrl") String challengeUrl, @Param(value="templateEngine") TemplateEngine templateEngine) {
        this.txmanager = txmanager;
        this.factory = factory;
        this.idurl = idUrl;
        this.authUrl = authUrl;
        this.challengeUrl = challengeUrl;
        this.templateEngine = templateEngine;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void provideHost(String name, int port) {
        this.host = name;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if (name.equals("login")) {
            this.mode = Mode.LOGIN;
        } else if (name.equals("newuser")) {
            this.mode = Mode.NEWUSER;
        } else if (name.equals("challengeid")) {
            this.challengeid = value;
        } else if (name.equals("username")) {
            this.username = value;
        } else if (name.equals("password")) {
            this.password = value;
        }
    }

    public void process(Responder resp) throws Exception {
        UnitOfWork uow = this.txmanager.newUnit();
        this.logger.info("Challenger: " + this.method + " #" + this.challengeid + " id " + this.idurl + (String)(this.mode != null ? ": " + this.mode : ""));
        resp.setTimeout(1000, TimeUnit.SECONDS);
        Relation r = uow.relation((RelationHandler)this);
        r.load((Object)resp);
        r.load("approve", (Object)(this.authUrl + "?challengeid=" + this.challengeid));
        r.load("rechallenge", (Object)(this.challengeUrl + "?challengeid=" + this.challengeid));
        r.get("claimedId", this.factory.simple("openid", this.host, "params", this.challengeid).toString(), x -> x != null ? x.getClaimedId() : null);
        r.logic("handleClaimedId");
        uow.enact();
    }

    public void handleClaimedId(Responder resp, UnitOfWork uow, Relation r, @Slot(value="claimedId") String claimedId) {
        block12: {
            try {
                if (this.method.equals("GET")) {
                    this.logger.info("Sending login template with " + (String)claimedId);
                    HashMap<String, String> model = new HashMap<String, String>();
                    model.put("tok", this.challengeid != null ? this.challengeid : "");
                    if (claimedId != null && ((String)claimedId).length() > this.idurl.length()) {
                        model.put("claimedId", (String)claimedId);
                    }
                    this.templateEngine.sendResource(resp, "challenge.fm", model);
                    resp.done();
                    return;
                }
                if (this.method.equals("POST")) {
                    this.logger.info("Attempting to log in with username " + this.username + " and mode " + this.mode);
                    switch (this.mode) {
                        case LOGIN: {
                            if (claimedId != null && ((String)claimedId).length() <= this.idurl.length() && this.username != null) {
                                claimedId = this.idurl + this.username;
                            }
                            this.logger.info("authenticating with claimedId = " + (String)claimedId);
                            this.authenticate(r, (String)claimedId);
                            break block12;
                        }
                        case NEWUSER: {
                            this.logger.info("Creating a new user " + this.username);
                            if (this.username == null || this.username.length() < 6 || this.password == null || this.password.length() < 8) {
                                this.logger.info("Rejecting user " + this.username + " because user or password is too short");
                                r.logic("sendRetry");
                            } else {
                                ZiId loginId = this.factory.simple("challenger", this.host, "login", this.username);
                                String salt = Crypto.generateSalt();
                                JVMLoginRecord saveAs = new JVMLoginRecord((FLEvalContext)uow, this.username, salt, Crypto.storePassword((String)this.password, (String)salt));
                                r.logic("createApproval");
                                r.whenCommitted("sendApproval");
                                r.create(loginId.toString(), (Object)saveAs);
                            }
                            break block12;
                        }
                        default: {
                            throw new RuntimeException("Neither login nore newuser were pressed");
                        }
                    }
                }
                throw new RuntimeException("Invalid method " + this.method);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                resp.setStatus(500);
                resp.done();
                return;
            }
        }
    }

    private void authenticate(Relation r, String claimedId) throws GLSException {
        if (claimedId == null || this.password == null || this.challengeid == null || !claimedId.startsWith(this.idurl)) {
            this.logger.info("failed due to null: claimedId = " + claimedId + " password = " + this.password + " tok = " + this.challengeid + (String)(claimedId != null ? " start = " + claimedId.startsWith(this.idurl) : ""));
            r.logic("sendRetry");
            return;
        }
        String asUser = claimedId.substring(this.idurl.length());
        ZiId loginId = this.factory.simple("challenger", this.host, "login", asUser);
        this.logger.info("Trying to load login record: " + loginId);
        r.logic("handleLoginRecord");
        r.get("loginRecord", loginId.toString());
    }

    public void handleLoginRecord(Relation r, @Slot(value="loginRecord") LoginRecord loginRecord, @Slot(value="claimedId") String claimedId) throws IOException, GLSException {
        if (loginRecord != null) {
            String salt = loginRecord.getSalt();
            String enc = loginRecord.getPassword();
            String curr = Crypto.storePassword((String)this.password, (String)salt);
            this.logger.info("Comparing record " + enc + " with new " + curr + " using salt " + salt);
            if (curr.equals(enc)) {
                this.logger.info("Challenge succeeded for " + claimedId);
                r.logic("createApproval");
                r.whenCommitted("sendApproval");
                return;
            }
            this.logger.info("Challenge failed for " + claimedId);
        } else {
            this.logger.info("No login record found for " + claimedId);
        }
        r.whenCommitted("sendRetry");
    }

    public void createApproval(UnitOfWork uow, Relation r) throws GLSException {
        ZiId approvalId = this.factory.simple("openid", this.host, "approvals", this.challengeid);
        r.whenRolledBack("sendRetry");
        r.upsert(approvalId.toString(), (Object)new JVMApprovalRecord((FLEvalContext)uow, approvalId, this.idurl + this.username));
    }

    public void sendApproval(Responder resp, @Slot(value="approve") String approve) throws IOException {
        resp.redirectTo(approve);
    }

    public void sendRetry(Responder resp, @Slot(value="rechallenge") String rechallenge) throws IOException {
        resp.redirectTo(rechallenge);
    }

    static enum Mode {
        NEWUSER,
        LOGIN;

    }
}

